/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExportsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListExportsResponse.Builder, ListExportsResponse> {
    private static final SdkField<List<Export>> EXPORTS_FIELD = SdkField
            .<List<Export>> builder(MarshallingType.LIST)
            .getter(getter(ListExportsResponse::exports))
            .setter(setter(Builder::exports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Export> builder(MarshallingType.SDK_POJO)
                                            .constructor(Export::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListExportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Export> exports;

    private final String nextToken;

    private ListExportsResponse(BuilderImpl builder) {
        super(builder);
        this.exports = builder.exports;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The output for the <a>ListExports</a> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The output for the <a>ListExports</a> action.
     */
    public List<Export> exports() {
        return exports;
    }

    /**
     * <p>
     * If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there is
     * no additional page, this value is null.
     * </p>
     * 
     * @return If the output exceeds 100 exported output values, a string that identifies the next page of exports. If
     *         there is no additional page, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exports());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse) obj;
        return Objects.equals(exports(), other.exports()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListExportsResponse").add("Exports", exports()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Exports":
            return Optional.ofNullable(clazz.cast(exports()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExportsResponse, T> g) {
        return obj -> g.apply((ListExportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListExportsResponse> {
        /**
         * <p>
         * The output for the <a>ListExports</a> action.
         * </p>
         * 
         * @param exports
         *        The output for the <a>ListExports</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(Collection<Export> exports);

        /**
         * <p>
         * The output for the <a>ListExports</a> action.
         * </p>
         * 
         * @param exports
         *        The output for the <a>ListExports</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(Export... exports);

        /**
         * <p>
         * The output for the <a>ListExports</a> action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Export>.Builder} avoiding the need to
         * create one manually via {@link List<Export>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Export>.Builder#build()} is called immediately and its
         * result is passed to {@link #exports(List<Export>)}.
         * 
         * @param exports
         *        a consumer that will call methods on {@link List<Export>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exports(List<Export>)
         */
        Builder exports(Consumer<Export.Builder>... exports);

        /**
         * <p>
         * If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there
         * is no additional page, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 100 exported output values, a string that identifies the next page of exports.
         *        If there is no additional page, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<Export> exports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            super(model);
            exports(model.exports);
            nextToken(model.nextToken);
        }

        public final Collection<Export.Builder> getExports() {
            return exports != null ? exports.stream().map(Export::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exports(Collection<Export> exports) {
            this.exports = ExportsCopier.copy(exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Export... exports) {
            exports(Arrays.asList(exports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Consumer<Export.Builder>... exports) {
            exports(Stream.of(exports).map(c -> Export.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExports(Collection<Export.BuilderImpl> exports) {
            this.exports = ExportsCopier.copyFromBuilder(exports);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
