/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ScannedResource;

public class ListResourceScanResourcesIterable
implements SdkIterable<ListResourceScanResourcesResponse> {
    private final CloudFormationClient client;
    private final ListResourceScanResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceScanResourcesIterable(CloudFormationClient client, ListResourceScanResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceScanResourcesResponseFetcher();
    }

    public Iterator<ListResourceScanResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScannedResource> resources() {
        Function<ListResourceScanResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceScanResourcesResponseFetcher
    implements SyncPageFetcher<ListResourceScanResourcesResponse> {
        private ListResourceScanResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceScanResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceScanResourcesResponse nextPage(ListResourceScanResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceScanResourcesIterable.this.client.listResourceScanResources(ListResourceScanResourcesIterable.this.firstRequest);
            }
            return ListResourceScanResourcesIterable.this.client.listResourceScanResources((ListResourceScanResourcesRequest)((Object)ListResourceScanResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

