/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.ChangeAction;
import software.amazon.awssdk.services.cloudformation.model.ModuleInfo;
import software.amazon.awssdk.services.cloudformation.model.PolicyAction;
import software.amazon.awssdk.services.cloudformation.model.Replacement;
import software.amazon.awssdk.services.cloudformation.model.ResourceAttribute;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetail;
import software.amazon.awssdk.services.cloudformation.model.ResourceChangeDetailsCopier;
import software.amazon.awssdk.services.cloudformation.model.ScopeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceChange> {
    private static final SdkField<String> POLICY_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyAction").getter(ResourceChange.getter(ResourceChange::policyActionAsString)).setter(ResourceChange.setter(Builder::policyAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAction").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(ResourceChange.getter(ResourceChange::actionAsString)).setter(ResourceChange.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalResourceId").getter(ResourceChange.getter(ResourceChange::logicalResourceId)).setter(ResourceChange.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalResourceId").getter(ResourceChange.getter(ResourceChange::physicalResourceId)).setter(ResourceChange.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceChange.getter(ResourceChange::resourceType)).setter(ResourceChange.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> REPLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Replacement").getter(ResourceChange.getter(ResourceChange::replacementAsString)).setter(ResourceChange.setter(Builder::replacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replacement").build()}).build();
    private static final SdkField<List<String>> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Scope").getter(ResourceChange.getter(ResourceChange::scopeAsStrings)).setter(ResourceChange.setter(Builder::scopeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceChangeDetail>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Details").getter(ResourceChange.getter(ResourceChange::details)).setter(ResourceChange.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceChangeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetId").getter(ResourceChange.getter(ResourceChange::changeSetId)).setter(ResourceChange.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()}).build();
    private static final SdkField<ModuleInfo> MODULE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModuleInfo").getter(ResourceChange.getter(ResourceChange::moduleInfo)).setter(ResourceChange.setter(Builder::moduleInfo)).constructor(ModuleInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModuleInfo").build()}).build();
    private static final SdkField<String> BEFORE_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BeforeContext").getter(ResourceChange.getter(ResourceChange::beforeContext)).setter(ResourceChange.setter(Builder::beforeContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeContext").build()}).build();
    private static final SdkField<String> AFTER_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfterContext").getter(ResourceChange.getter(ResourceChange::afterContext)).setter(ResourceChange.setter(Builder::afterContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ACTION_FIELD, ACTION_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, REPLACEMENT_FIELD, SCOPE_FIELD, DETAILS_FIELD, CHANGE_SET_ID_FIELD, MODULE_INFO_FIELD, BEFORE_CONTEXT_FIELD, AFTER_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceChange.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyAction;
    private final String action;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final String replacement;
    private final List<String> scope;
    private final List<ResourceChangeDetail> details;
    private final String changeSetId;
    private final ModuleInfo moduleInfo;
    private final String beforeContext;
    private final String afterContext;

    private ResourceChange(BuilderImpl builder) {
        this.policyAction = builder.policyAction;
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
        this.changeSetId = builder.changeSetId;
        this.moduleInfo = builder.moduleInfo;
        this.beforeContext = builder.beforeContext;
        this.afterContext = builder.afterContext;
    }

    public final PolicyAction policyAction() {
        return PolicyAction.fromValue(this.policyAction);
    }

    public final String policyActionAsString() {
        return this.policyAction;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Replacement replacement() {
        return Replacement.fromValue(this.replacement);
    }

    public final String replacementAsString() {
        return this.replacement;
    }

    public final List<ResourceAttribute> scope() {
        return ScopeCopier.copyStringToEnum(this.scope);
    }

    public final boolean hasScope() {
        return this.scope != null && !(this.scope instanceof SdkAutoConstructList);
    }

    public final List<String> scopeAsStrings() {
        return this.scope;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public final List<ResourceChangeDetail> details() {
        return this.details;
    }

    public final String changeSetId() {
        return this.changeSetId;
    }

    public final ModuleInfo moduleInfo() {
        return this.moduleInfo;
    }

    public final String beforeContext() {
        return this.beforeContext;
    }

    public final String afterContext() {
        return this.afterContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScope() ? this.scopeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.moduleInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange)obj;
        return Objects.equals(this.policyActionAsString(), other.policyActionAsString()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.replacementAsString(), other.replacementAsString()) && this.hasScope() == other.hasScope() && Objects.equals(this.scopeAsStrings(), other.scopeAsStrings()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details()) && Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.moduleInfo(), other.moduleInfo()) && Objects.equals(this.beforeContext(), other.beforeContext()) && Objects.equals(this.afterContext(), other.afterContext());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceChange").add("PolicyAction", (Object)this.policyActionAsString()).add("Action", (Object)this.actionAsString()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("Replacement", (Object)this.replacementAsString()).add("Scope", this.hasScope() ? this.scopeAsStrings() : null).add("Details", this.hasDetails() ? this.details() : null).add("ChangeSetId", (Object)this.changeSetId()).add("ModuleInfo", (Object)this.moduleInfo()).add("BeforeContext", (Object)this.beforeContext()).add("AfterContext", (Object)this.afterContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyAction": {
                return Optional.ofNullable(clazz.cast(this.policyActionAsString()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Replacement": {
                return Optional.ofNullable(clazz.cast(this.replacementAsString()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsStrings()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
            case "ModuleInfo": {
                return Optional.ofNullable(clazz.cast(this.moduleInfo()));
            }
            case "BeforeContext": {
                return Optional.ofNullable(clazz.cast(this.beforeContext()));
            }
            case "AfterContext": {
                return Optional.ofNullable(clazz.cast(this.afterContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyAction", POLICY_ACTION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("PhysicalResourceId", PHYSICAL_RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Replacement", REPLACEMENT_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Details", DETAILS_FIELD);
        map.put("ChangeSetId", CHANGE_SET_ID_FIELD);
        map.put("ModuleInfo", MODULE_INFO_FIELD);
        map.put("BeforeContext", BEFORE_CONTEXT_FIELD);
        map.put("AfterContext", AFTER_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceChange, T> g) {
        return obj -> g.apply((ResourceChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyAction;
        private String action;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private String replacement;
        private List<String> scope = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceChangeDetail> details = DefaultSdkAutoConstructList.getInstance();
        private String changeSetId;
        private ModuleInfo moduleInfo;
        private String beforeContext;
        private String afterContext;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            this.policyAction(model.policyAction);
            this.action(model.action);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.replacement(model.replacement);
            this.scopeWithStrings(model.scope);
            this.details(model.details);
            this.changeSetId(model.changeSetId);
            this.moduleInfo(model.moduleInfo);
            this.beforeContext(model.beforeContext);
            this.afterContext(model.afterContext);
        }

        public final String getPolicyAction() {
            return this.policyAction;
        }

        public final void setPolicyAction(String policyAction) {
            this.policyAction = policyAction;
        }

        @Override
        public final Builder policyAction(String policyAction) {
            this.policyAction = policyAction;
            return this;
        }

        @Override
        public final Builder policyAction(PolicyAction policyAction) {
            this.policyAction(policyAction == null ? null : policyAction.toString());
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getReplacement() {
            return this.replacement;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement == null ? null : replacement.toString());
            return this;
        }

        public final Collection<String> getScope() {
            if (this.scope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        @Override
        public final Builder scopeWithStrings(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopeWithStrings(String ... scope) {
            this.scopeWithStrings(Arrays.asList(scope));
            return this;
        }

        @Override
        public final Builder scope(Collection<ResourceAttribute> scope) {
            this.scope = ScopeCopier.copyEnumToString(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(ResourceAttribute ... scope) {
            this.scope(Arrays.asList(scope));
            return this;
        }

        public final List<ResourceChangeDetail.Builder> getDetails() {
            List<ResourceChangeDetail.Builder> result = ResourceChangeDetailsCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<ResourceChangeDetail.BuilderImpl> details) {
            this.details = ResourceChangeDetailsCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<ResourceChangeDetail.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (ResourceChangeDetail)((ResourceChangeDetail.Builder)ResourceChangeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final ModuleInfo.Builder getModuleInfo() {
            return this.moduleInfo != null ? this.moduleInfo.toBuilder() : null;
        }

        public final void setModuleInfo(ModuleInfo.BuilderImpl moduleInfo) {
            this.moduleInfo = moduleInfo != null ? moduleInfo.build() : null;
        }

        @Override
        public final Builder moduleInfo(ModuleInfo moduleInfo) {
            this.moduleInfo = moduleInfo;
            return this;
        }

        public final String getBeforeContext() {
            return this.beforeContext;
        }

        public final void setBeforeContext(String beforeContext) {
            this.beforeContext = beforeContext;
        }

        @Override
        public final Builder beforeContext(String beforeContext) {
            this.beforeContext = beforeContext;
            return this;
        }

        public final String getAfterContext() {
            return this.afterContext;
        }

        public final void setAfterContext(String afterContext) {
            this.afterContext = afterContext;
        }

        @Override
        public final Builder afterContext(String afterContext) {
            this.afterContext = afterContext;
            return this;
        }

        public ResourceChange build() {
            return new ResourceChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceChange> {
        public Builder policyAction(String var1);

        public Builder policyAction(PolicyAction var1);

        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder replacement(String var1);

        public Builder replacement(Replacement var1);

        public Builder scopeWithStrings(Collection<String> var1);

        public Builder scopeWithStrings(String ... var1);

        public Builder scope(Collection<ResourceAttribute> var1);

        public Builder scope(ResourceAttribute ... var1);

        public Builder details(Collection<ResourceChangeDetail> var1);

        public Builder details(ResourceChangeDetail ... var1);

        public Builder details(Consumer<ResourceChangeDetail.Builder> ... var1);

        public Builder changeSetId(String var1);

        public Builder moduleInfo(ModuleInfo var1);

        default public Builder moduleInfo(Consumer<ModuleInfo.Builder> moduleInfo) {
            return this.moduleInfo((ModuleInfo)((ModuleInfo.Builder)ModuleInfo.builder().applyMutation(moduleInfo)).build());
        }

        public Builder beforeContext(String var1);

        public Builder afterContext(String var1);
    }
}

