/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.AutoDeployment;
import software.amazon.awssdk.services.cloudformation.model.CallAs;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ManagedExecution;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.PermissionModels;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStackSetRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, CreateStackSetRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(CreateStackSetRequest.getter(CreateStackSetRequest::stackSetName)).setter(CreateStackSetRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateStackSetRequest.getter(CreateStackSetRequest::description)).setter(CreateStackSetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(CreateStackSetRequest.getter(CreateStackSetRequest::templateBody)).setter(CreateStackSetRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateURL").getter(CreateStackSetRequest.getter(CreateStackSetRequest::templateURL)).setter(CreateStackSetRequest.setter(Builder::templateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(CreateStackSetRequest.getter(CreateStackSetRequest::stackId)).setter(CreateStackSetRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(CreateStackSetRequest.getter(CreateStackSetRequest::parameters)).setter(CreateStackSetRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(CreateStackSetRequest.getter(CreateStackSetRequest::capabilitiesAsStrings)).setter(CreateStackSetRequest.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateStackSetRequest.getter(CreateStackSetRequest::tags)).setter(CreateStackSetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADMINISTRATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdministrationRoleARN").getter(CreateStackSetRequest.getter(CreateStackSetRequest::administrationRoleARN)).setter(CreateStackSetRequest.setter(Builder::administrationRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrationRoleARN").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleName").getter(CreateStackSetRequest.getter(CreateStackSetRequest::executionRoleName)).setter(CreateStackSetRequest.setter(Builder::executionRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()}).build();
    private static final SdkField<String> PERMISSION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionModel").getter(CreateStackSetRequest.getter(CreateStackSetRequest::permissionModelAsString)).setter(CreateStackSetRequest.setter(Builder::permissionModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionModel").build()}).build();
    private static final SdkField<AutoDeployment> AUTO_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoDeployment").getter(CreateStackSetRequest.getter(CreateStackSetRequest::autoDeployment)).setter(CreateStackSetRequest.setter(Builder::autoDeployment)).constructor(AutoDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeployment").build()}).build();
    private static final SdkField<String> CALL_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAs").getter(CreateStackSetRequest.getter(CreateStackSetRequest::callAsAsString)).setter(CreateStackSetRequest.setter(Builder::callAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateStackSetRequest.getter(CreateStackSetRequest::clientRequestToken)).setter(CreateStackSetRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ManagedExecution> MANAGED_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedExecution").getter(CreateStackSetRequest.getter(CreateStackSetRequest::managedExecution)).setter(CreateStackSetRequest.setter(Builder::managedExecution)).constructor(ManagedExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedExecution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, STACK_ID_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD, TAGS_FIELD, ADMINISTRATION_ROLE_ARN_FIELD, EXECUTION_ROLE_NAME_FIELD, PERMISSION_MODEL_FIELD, AUTO_DEPLOYMENT_FIELD, CALL_AS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, MANAGED_EXECUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStackSetRequest.memberNameToFieldInitializer();
    private final String stackSetName;
    private final String description;
    private final String templateBody;
    private final String templateURL;
    private final String stackId;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<Tag> tags;
    private final String administrationRoleARN;
    private final String executionRoleName;
    private final String permissionModel;
    private final AutoDeployment autoDeployment;
    private final String callAs;
    private final String clientRequestToken;
    private final ManagedExecution managedExecution;

    private CreateStackSetRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.description = builder.description;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.stackId = builder.stackId;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.administrationRoleARN = builder.administrationRoleARN;
        this.executionRoleName = builder.executionRoleName;
        this.permissionModel = builder.permissionModel;
        this.autoDeployment = builder.autoDeployment;
        this.callAs = builder.callAs;
        this.clientRequestToken = builder.clientRequestToken;
        this.managedExecution = builder.managedExecution;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final String description() {
        return this.description;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final String templateURL() {
        return this.templateURL;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameters() {
        return this.parameters;
    }

    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String administrationRoleARN() {
        return this.administrationRoleARN;
    }

    public final String executionRoleName() {
        return this.executionRoleName;
    }

    public final PermissionModels permissionModel() {
        return PermissionModels.fromValue(this.permissionModel);
    }

    public final String permissionModelAsString() {
        return this.permissionModel;
    }

    public final AutoDeployment autoDeployment() {
        return this.autoDeployment;
    }

    public final CallAs callAs() {
        return CallAs.fromValue(this.callAs);
    }

    public final String callAsAsString() {
        return this.callAs;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final ManagedExecution managedExecution() {
        return this.managedExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.administrationRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedExecution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackSetRequest)) {
            return false;
        }
        CreateStackSetRequest other = (CreateStackSetRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.stackId(), other.stackId()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.administrationRoleARN(), other.administrationRoleARN()) && Objects.equals(this.executionRoleName(), other.executionRoleName()) && Objects.equals(this.permissionModelAsString(), other.permissionModelAsString()) && Objects.equals(this.autoDeployment(), other.autoDeployment()) && Objects.equals(this.callAsAsString(), other.callAsAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.managedExecution(), other.managedExecution());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStackSetRequest").add("StackSetName", (Object)this.stackSetName()).add("Description", (Object)this.description()).add("TemplateBody", (Object)this.templateBody()).add("TemplateURL", (Object)this.templateURL()).add("StackId", (Object)this.stackId()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("Tags", this.hasTags() ? this.tags() : null).add("AdministrationRoleARN", (Object)this.administrationRoleARN()).add("ExecutionRoleName", (Object)this.executionRoleName()).add("PermissionModel", (Object)this.permissionModelAsString()).add("AutoDeployment", (Object)this.autoDeployment()).add("CallAs", (Object)this.callAsAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("ManagedExecution", (Object)this.managedExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.ofNullable(clazz.cast(this.templateURL()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AdministrationRoleARN": {
                return Optional.ofNullable(clazz.cast(this.administrationRoleARN()));
            }
            case "ExecutionRoleName": {
                return Optional.ofNullable(clazz.cast(this.executionRoleName()));
            }
            case "PermissionModel": {
                return Optional.ofNullable(clazz.cast(this.permissionModelAsString()));
            }
            case "AutoDeployment": {
                return Optional.ofNullable(clazz.cast(this.autoDeployment()));
            }
            case "CallAs": {
                return Optional.ofNullable(clazz.cast(this.callAsAsString()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ManagedExecution": {
                return Optional.ofNullable(clazz.cast(this.managedExecution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackSetName", STACK_SET_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TemplateBody", TEMPLATE_BODY_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AdministrationRoleARN", ADMINISTRATION_ROLE_ARN_FIELD);
        map.put("ExecutionRoleName", EXECUTION_ROLE_NAME_FIELD);
        map.put("PermissionModel", PERMISSION_MODEL_FIELD);
        map.put("AutoDeployment", AUTO_DEPLOYMENT_FIELD);
        map.put("CallAs", CALL_AS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("ManagedExecution", MANAGED_EXECUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStackSetRequest, T> g) {
        return obj -> g.apply((CreateStackSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackSetName;
        private String description;
        private String templateBody;
        private String templateURL;
        private String stackId;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String administrationRoleARN;
        private String executionRoleName;
        private String permissionModel;
        private AutoDeployment autoDeployment;
        private String callAs;
        private String clientRequestToken;
        private ManagedExecution managedExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackSetRequest model) {
            super(model);
            this.stackSetName(model.stackSetName);
            this.description(model.description);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.stackId(model.stackId);
            this.parameters(model.parameters);
            this.capabilitiesWithStrings(model.capabilities);
            this.tags(model.tags);
            this.administrationRoleARN(model.administrationRoleARN);
            this.executionRoleName(model.executionRoleName);
            this.permissionModel(model.permissionModel);
            this.autoDeployment(model.autoDeployment);
            this.callAs(model.callAs);
            this.clientRequestToken(model.clientRequestToken);
            this.managedExecution(model.managedExecution);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAdministrationRoleARN() {
            return this.administrationRoleARN;
        }

        public final void setAdministrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
        }

        @Override
        public final Builder administrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
            return this;
        }

        public final String getExecutionRoleName() {
            return this.executionRoleName;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final String getPermissionModel() {
            return this.permissionModel;
        }

        public final void setPermissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
        }

        @Override
        public final Builder permissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        @Override
        public final Builder permissionModel(PermissionModels permissionModel) {
            this.permissionModel(permissionModel == null ? null : permissionModel.toString());
            return this;
        }

        public final AutoDeployment.Builder getAutoDeployment() {
            return this.autoDeployment != null ? this.autoDeployment.toBuilder() : null;
        }

        public final void setAutoDeployment(AutoDeployment.BuilderImpl autoDeployment) {
            this.autoDeployment = autoDeployment != null ? autoDeployment.build() : null;
        }

        @Override
        public final Builder autoDeployment(AutoDeployment autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        public final String getCallAs() {
            return this.callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ManagedExecution.Builder getManagedExecution() {
            return this.managedExecution != null ? this.managedExecution.toBuilder() : null;
        }

        public final void setManagedExecution(ManagedExecution.BuilderImpl managedExecution) {
            this.managedExecution = managedExecution != null ? managedExecution.build() : null;
        }

        @Override
        public final Builder managedExecution(ManagedExecution managedExecution) {
            this.managedExecution = managedExecution;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackSetRequest build() {
            return new CreateStackSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStackSetRequest> {
        public Builder stackSetName(String var1);

        public Builder description(String var1);

        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder stackId(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder administrationRoleARN(String var1);

        public Builder executionRoleName(String var1);

        public Builder permissionModel(String var1);

        public Builder permissionModel(PermissionModels var1);

        public Builder autoDeployment(AutoDeployment var1);

        default public Builder autoDeployment(Consumer<AutoDeployment.Builder> autoDeployment) {
            return this.autoDeployment((AutoDeployment)((AutoDeployment.Builder)AutoDeployment.builder().applyMutation(autoDeployment)).build());
        }

        public Builder callAs(String var1);

        public Builder callAs(CallAs var1);

        public Builder clientRequestToken(String var1);

        public Builder managedExecution(ManagedExecution var1);

        default public Builder managedExecution(Consumer<ManagedExecution.Builder> managedExecution) {
            return this.managedExecution((ManagedExecution)((ManagedExecution.Builder)ManagedExecution.builder().applyMutation(managedExecution)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

