/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetSummary;

public class ListStackSetsIterable
implements SdkIterable<ListStackSetsResponse> {
    private final CloudFormationClient client;
    private final ListStackSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackSetsIterable(CloudFormationClient client, ListStackSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStackSetsResponseFetcher();
    }

    public Iterator<ListStackSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackSetSummary> summaries() {
        Function<ListStackSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStackSetsResponseFetcher
    implements SyncPageFetcher<ListStackSetsResponse> {
        private ListStackSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStackSetsResponse nextPage(ListStackSetsResponse previousPage) {
            if (previousPage == null) {
                return ListStackSetsIterable.this.client.listStackSets(ListStackSetsIterable.this.firstRequest);
            }
            return ListStackSetsIterable.this.client.listStackSets((ListStackSetsRequest)((Object)ListStackSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

