/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ParameterConstraints;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterDeclaration> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterKey").getter(ParameterDeclaration.getter(ParameterDeclaration::parameterKey)).setter(ParameterDeclaration.setter(Builder::parameterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(ParameterDeclaration.getter(ParameterDeclaration::defaultValue)).setter(ParameterDeclaration.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> PARAMETER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterType").getter(ParameterDeclaration.getter(ParameterDeclaration::parameterType)).setter(ParameterDeclaration.setter(Builder::parameterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterType").build()}).build();
    private static final SdkField<Boolean> NO_ECHO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoEcho").getter(ParameterDeclaration.getter(ParameterDeclaration::noEcho)).setter(ParameterDeclaration.setter(Builder::noEcho)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoEcho").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ParameterDeclaration.getter(ParameterDeclaration::description)).setter(ParameterDeclaration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ParameterConstraints> PARAMETER_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParameterConstraints").getter(ParameterDeclaration.getter(ParameterDeclaration::parameterConstraints)).setter(ParameterDeclaration.setter(Builder::parameterConstraints)).constructor(ParameterConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterConstraints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD, DEFAULT_VALUE_FIELD, PARAMETER_TYPE_FIELD, NO_ECHO_FIELD, DESCRIPTION_FIELD, PARAMETER_CONSTRAINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ParameterKey", PARAMETER_KEY_FIELD);
            this.put("DefaultValue", DEFAULT_VALUE_FIELD);
            this.put("ParameterType", PARAMETER_TYPE_FIELD);
            this.put("NoEcho", NO_ECHO_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ParameterConstraints", PARAMETER_CONSTRAINTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String parameterKey;
    private final String defaultValue;
    private final String parameterType;
    private final Boolean noEcho;
    private final String description;
    private final ParameterConstraints parameterConstraints;

    private ParameterDeclaration(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.parameterType = builder.parameterType;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
        this.parameterConstraints = builder.parameterConstraints;
    }

    public final String parameterKey() {
        return this.parameterKey;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String parameterType() {
        return this.parameterType;
    }

    public final Boolean noEcho() {
        return this.noEcho;
    }

    public final String description() {
        return this.description;
    }

    public final ParameterConstraints parameterConstraints() {
        return this.parameterConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterConstraints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDeclaration)) {
            return false;
        }
        ParameterDeclaration other = (ParameterDeclaration)obj;
        return Objects.equals(this.parameterKey(), other.parameterKey()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.parameterType(), other.parameterType()) && Objects.equals(this.noEcho(), other.noEcho()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parameterConstraints(), other.parameterConstraints());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterDeclaration").add("ParameterKey", (Object)this.parameterKey()).add("DefaultValue", (Object)this.defaultValue()).add("ParameterType", (Object)this.parameterType()).add("NoEcho", (Object)this.noEcho()).add("Description", (Object)this.description()).add("ParameterConstraints", (Object)this.parameterConstraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterKey": {
                return Optional.ofNullable(clazz.cast(this.parameterKey()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "ParameterType": {
                return Optional.ofNullable(clazz.cast(this.parameterType()));
            }
            case "NoEcho": {
                return Optional.ofNullable(clazz.cast(this.noEcho()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ParameterConstraints": {
                return Optional.ofNullable(clazz.cast(this.parameterConstraints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ParameterDeclaration, T> g) {
        return obj -> g.apply((ParameterDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterKey;
        private String defaultValue;
        private String parameterType;
        private Boolean noEcho;
        private String description;
        private ParameterConstraints parameterConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDeclaration model) {
            this.parameterKey(model.parameterKey);
            this.defaultValue(model.defaultValue);
            this.parameterType(model.parameterType);
            this.noEcho(model.noEcho);
            this.description(model.description);
            this.parameterConstraints(model.parameterConstraints);
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getParameterType() {
            return this.parameterType;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public final Boolean getNoEcho() {
            return this.noEcho;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ParameterConstraints.Builder getParameterConstraints() {
            return this.parameterConstraints != null ? this.parameterConstraints.toBuilder() : null;
        }

        public final void setParameterConstraints(ParameterConstraints.BuilderImpl parameterConstraints) {
            this.parameterConstraints = parameterConstraints != null ? parameterConstraints.build() : null;
        }

        @Override
        public final Builder parameterConstraints(ParameterConstraints parameterConstraints) {
            this.parameterConstraints = parameterConstraints;
            return this;
        }

        public ParameterDeclaration build() {
            return new ParameterDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterDeclaration> {
        public Builder parameterKey(String var1);

        public Builder defaultValue(String var1);

        public Builder parameterType(String var1);

        public Builder noEcho(Boolean var1);

        public Builder description(String var1);

        public Builder parameterConstraints(ParameterConstraints var1);

        default public Builder parameterConstraints(Consumer<ParameterConstraints.Builder> parameterConstraints) {
            return this.parameterConstraints((ParameterConstraints)((ParameterConstraints.Builder)ParameterConstraints.builder().applyMutation(parameterConstraints)).build());
        }
    }
}

