/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.TemplateParameter;
import software.amazon.awssdk.services.cloudformation.model.TemplateParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.TransformsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateTemplateResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ValidateTemplateResponse> {
    private static final SdkField<List<TemplateParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(ValidateTemplateResponse.getter(ValidateTemplateResponse::parameters)).setter(ValidateTemplateResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ValidateTemplateResponse.getter(ValidateTemplateResponse::description)).setter(ValidateTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(ValidateTemplateResponse.getter(ValidateTemplateResponse::capabilitiesAsStrings)).setter(ValidateTemplateResponse.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CAPABILITIES_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapabilitiesReason").getter(ValidateTemplateResponse.getter(ValidateTemplateResponse::capabilitiesReason)).setter(ValidateTemplateResponse.setter(Builder::capabilitiesReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapabilitiesReason").build()}).build();
    private static final SdkField<List<String>> DECLARED_TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeclaredTransforms").getter(ValidateTemplateResponse.getter(ValidateTemplateResponse::declaredTransforms)).setter(ValidateTemplateResponse.setter(Builder::declaredTransforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeclaredTransforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD, DESCRIPTION_FIELD, CAPABILITIES_FIELD, CAPABILITIES_REASON_FIELD, DECLARED_TRANSFORMS_FIELD));
    private final List<TemplateParameter> parameters;
    private final String description;
    private final List<String> capabilities;
    private final String capabilitiesReason;
    private final List<String> declaredTransforms;

    private ValidateTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.declaredTransforms = builder.declaredTransforms;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<TemplateParameter> parameters() {
        return this.parameters;
    }

    public final String description() {
        return this.description;
    }

    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final String capabilitiesReason() {
        return this.capabilitiesReason;
    }

    public final boolean hasDeclaredTransforms() {
        return this.declaredTransforms != null && !(this.declaredTransforms instanceof SdkAutoConstructList);
    }

    public final List<String> declaredTransforms() {
        return this.declaredTransforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeclaredTransforms() ? this.declaredTransforms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTemplateResponse)) {
            return false;
        }
        ValidateTemplateResponse other = (ValidateTemplateResponse)((Object)obj);
        return this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.description(), other.description()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.capabilitiesReason(), other.capabilitiesReason()) && this.hasDeclaredTransforms() == other.hasDeclaredTransforms() && Objects.equals(this.declaredTransforms(), other.declaredTransforms());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateTemplateResponse").add("Parameters", this.hasParameters() ? this.parameters() : null).add("Description", (Object)this.description()).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("CapabilitiesReason", (Object)this.capabilitiesReason()).add("DeclaredTransforms", this.hasDeclaredTransforms() ? this.declaredTransforms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "CapabilitiesReason": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesReason()));
            }
            case "DeclaredTransforms": {
                return Optional.ofNullable(clazz.cast(this.declaredTransforms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateTemplateResponse, T> g) {
        return obj -> g.apply((ValidateTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<TemplateParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private String capabilitiesReason;
        private List<String> declaredTransforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateTemplateResponse model) {
            super(model);
            this.parameters(model.parameters);
            this.description(model.description);
            this.capabilitiesWithStrings(model.capabilities);
            this.capabilitiesReason(model.capabilitiesReason);
            this.declaredTransforms(model.declaredTransforms);
        }

        public final List<TemplateParameter.Builder> getParameters() {
            List<TemplateParameter.Builder> result = TemplateParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<TemplateParameter.BuilderImpl> parameters) {
            this.parameters = TemplateParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<TemplateParameter> parameters) {
            this.parameters = TemplateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(TemplateParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<TemplateParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (TemplateParameter)((TemplateParameter.Builder)TemplateParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getCapabilitiesReason() {
            return this.capabilitiesReason;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final Collection<String> getDeclaredTransforms() {
            if (this.declaredTransforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.declaredTransforms;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String ... declaredTransforms) {
            this.declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        @Override
        public ValidateTemplateResponse build() {
            return new ValidateTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateTemplateResponse> {
        public Builder parameters(Collection<TemplateParameter> var1);

        public Builder parameters(TemplateParameter ... var1);

        public Builder parameters(Consumer<TemplateParameter.Builder> ... var1);

        public Builder description(String var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder capabilitiesReason(String var1);

        public Builder declaredTransforms(Collection<String> var1);

        public Builder declaredTransforms(String ... var1);
    }
}

