/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationResultSummary;

public class ListStackSetOperationResultsPublisher
implements SdkPublisher<ListStackSetOperationResultsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStackSetOperationResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStackSetOperationResultsPublisher(CloudFormationAsyncClient client, ListStackSetOperationResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStackSetOperationResultsPublisher(CloudFormationAsyncClient client, ListStackSetOperationResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStackSetOperationResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStackSetOperationResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackSetOperationResultSummary> summaries() {
        Function<ListStackSetOperationResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStackSetOperationResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStackSetOperationResultsResponseFetcher
    implements AsyncPageFetcher<ListStackSetOperationResultsResponse> {
        private ListStackSetOperationResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackSetOperationResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStackSetOperationResultsResponse> nextPage(ListStackSetOperationResultsResponse previousPage) {
            if (previousPage == null) {
                return ListStackSetOperationResultsPublisher.this.client.listStackSetOperationResults(ListStackSetOperationResultsPublisher.this.firstRequest);
            }
            return ListStackSetOperationResultsPublisher.this.client.listStackSetOperationResults((ListStackSetOperationResultsRequest)((Object)ListStackSetOperationResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

