/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.TypeSummary;

public class ListTypesPublisher
implements SdkPublisher<ListTypesResponse> {
    private final CloudFormationAsyncClient client;
    private final ListTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTypesPublisher(CloudFormationAsyncClient client, ListTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTypesPublisher(CloudFormationAsyncClient client, ListTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TypeSummary> typeSummaries() {
        Function<ListTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.typeSummaries() != null) {
                return response.typeSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTypesResponseFetcher
    implements AsyncPageFetcher<ListTypesResponse> {
        private ListTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTypesResponse> nextPage(ListTypesResponse previousPage) {
            if (previousPage == null) {
                return ListTypesPublisher.this.client.listTypes(ListTypesPublisher.this.firstRequest);
            }
            return ListTypesPublisher.this.client.listTypes((ListTypesRequest)((Object)ListTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

