/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackInstanceResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackInstanceResponse.Builder, DescribeStackInstanceResponse> {
    private static final SdkField<StackInstance> STACK_INSTANCE_FIELD = SdkField
            .<StackInstance> builder(MarshallingType.SDK_POJO).memberName("StackInstance")
            .getter(getter(DescribeStackInstanceResponse::stackInstance)).setter(setter(Builder::stackInstance))
            .constructor(StackInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_INSTANCE_FIELD));

    private final StackInstance stackInstance;

    private DescribeStackInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.stackInstance = builder.stackInstance;
    }

    /**
     * <p>
     * The stack instance that matches the specified request parameters.
     * </p>
     * 
     * @return The stack instance that matches the specified request parameters.
     */
    public final StackInstance stackInstance() {
        return stackInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackInstanceResponse)) {
            return false;
        }
        DescribeStackInstanceResponse other = (DescribeStackInstanceResponse) obj;
        return Objects.equals(stackInstance(), other.stackInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackInstanceResponse").add("StackInstance", stackInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackInstance":
            return Optional.ofNullable(clazz.cast(stackInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackInstanceResponse, T> g) {
        return obj -> g.apply((DescribeStackInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackInstanceResponse> {
        /**
         * <p>
         * The stack instance that matches the specified request parameters.
         * </p>
         * 
         * @param stackInstance
         *        The stack instance that matches the specified request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstance(StackInstance stackInstance);

        /**
         * <p>
         * The stack instance that matches the specified request parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link StackInstance.Builder} avoiding the need
         * to create one manually via {@link StackInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #stackInstance(StackInstance)}.
         * 
         * @param stackInstance
         *        a consumer that will call methods on {@link StackInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackInstance(StackInstance)
         */
        default Builder stackInstance(Consumer<StackInstance.Builder> stackInstance) {
            return stackInstance(StackInstance.builder().applyMutation(stackInstance).build());
        }
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private StackInstance stackInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackInstanceResponse model) {
            super(model);
            stackInstance(model.stackInstance);
        }

        public final StackInstance.Builder getStackInstance() {
            return stackInstance != null ? stackInstance.toBuilder() : null;
        }

        public final void setStackInstance(StackInstance.BuilderImpl stackInstance) {
            this.stackInstance = stackInstance != null ? stackInstance.build() : null;
        }

        @Override
        public final Builder stackInstance(StackInstance stackInstance) {
            this.stackInstance = stackInstance;
            return this;
        }

        @Override
        public DescribeStackInstanceResponse build() {
            return new DescribeStackInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
