/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTypeRegistrationRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeTypeRegistrationRequest.Builder, DescribeTypeRegistrationRequest> {
    private static final SdkField<String> REGISTRATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistrationToken").getter(getter(DescribeTypeRegistrationRequest::registrationToken))
            .setter(setter(Builder::registrationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TOKEN_FIELD));

    private final String registrationToken;

    private DescribeTypeRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.registrationToken = builder.registrationToken;
    }

    /**
     * <p>
     * The identifier for this registration request.
     * </p>
     * <p>
     * This registration token is generated by CloudFormation when you initiate a registration request using
     * <code> <a>RegisterType</a> </code>.
     * </p>
     * 
     * @return The identifier for this registration request.</p>
     *         <p>
     *         This registration token is generated by CloudFormation when you initiate a registration request using
     *         <code> <a>RegisterType</a> </code>.
     */
    public final String registrationToken() {
        return registrationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeRegistrationRequest)) {
            return false;
        }
        DescribeTypeRegistrationRequest other = (DescribeTypeRegistrationRequest) obj;
        return Objects.equals(registrationToken(), other.registrationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTypeRegistrationRequest").add("RegistrationToken", registrationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationToken":
            return Optional.ofNullable(clazz.cast(registrationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeRegistrationRequest, T> g) {
        return obj -> g.apply((DescribeTypeRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTypeRegistrationRequest> {
        /**
         * <p>
         * The identifier for this registration request.
         * </p>
         * <p>
         * This registration token is generated by CloudFormation when you initiate a registration request using
         * <code> <a>RegisterType</a> </code>.
         * </p>
         * 
         * @param registrationToken
         *        The identifier for this registration request.</p>
         *        <p>
         *        This registration token is generated by CloudFormation when you initiate a registration request using
         *        <code> <a>RegisterType</a> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationToken(String registrationToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String registrationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeRegistrationRequest model) {
            super(model);
            registrationToken(model.registrationToken);
        }

        public final String getRegistrationToken() {
            return registrationToken;
        }

        @Override
        public final Builder registrationToken(String registrationToken) {
            this.registrationToken = registrationToken;
            return this;
        }

        public final void setRegistrationToken(String registrationToken) {
            this.registrationToken = registrationToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTypeRegistrationRequest build() {
            return new DescribeTypeRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
