/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about the specified CloudFormation type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypeSummary implements SdkPojo, Serializable, ToCopyableBuilder<TypeSummary.Builder, TypeSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TypeSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(TypeSummary::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultVersionId").getter(getter(TypeSummary::defaultVersionId))
            .setter(setter(Builder::defaultVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()).build();

    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(TypeSummary::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(TypeSummary::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TypeSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            DEFAULT_VERSION_ID_FIELD, TYPE_ARN_FIELD, LAST_UPDATED_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String typeName;

    private final String defaultVersionId;

    private final String typeArn;

    private final Instant lastUpdated;

    private final String description;

    private TypeSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.typeArn = builder.typeArn;
        this.lastUpdated = builder.lastUpdated;
        this.description = builder.description;
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type.
     * @see RegistryType
     */
    public final RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type.
     * @see RegistryType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the type.
     * </p>
     * 
     * @return The name of the type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The ID of the default version of the type. The default version is used when the type version is not specified.
     * </p>
     * <p>
     * To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
     * </p>
     * 
     * @return The ID of the default version of the type. The default version is used when the type version is not
     *         specified.</p>
     *         <p>
     *         To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
     */
    public final String defaultVersionId() {
        return defaultVersionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the type.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the type.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * When the current default version of the type was registered.
     * </p>
     * 
     * @return When the current default version of the type was registered.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The description of the type.
     * </p>
     * 
     * @return The description of the type.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeSummary)) {
            return false;
        }
        TypeSummary other = (TypeSummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(defaultVersionId(), other.defaultVersionId()) && Objects.equals(typeArn(), other.typeArn())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypeSummary").add("Type", typeAsString()).add("TypeName", typeName())
                .add("DefaultVersionId", defaultVersionId()).add("TypeArn", typeArn()).add("LastUpdated", lastUpdated())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "DefaultVersionId":
            return Optional.ofNullable(clazz.cast(defaultVersionId()));
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeSummary, T> g) {
        return obj -> g.apply((TypeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypeSummary> {
        /**
         * <p>
         * The kind of type.
         * </p>
         * 
         * @param type
         *        The kind of type.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of type.
         * </p>
         * 
         * @param type
         *        The kind of type.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the type.
         * </p>
         * 
         * @param typeName
         *        The name of the type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The ID of the default version of the type. The default version is used when the type version is not
         * specified.
         * </p>
         * <p>
         * To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
         * </p>
         * 
         * @param defaultVersionId
         *        The ID of the default version of the type. The default version is used when the type version is not
         *        specified.</p>
         *        <p>
         *        To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(String defaultVersionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the type.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) of the type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * When the current default version of the type was registered.
         * </p>
         * 
         * @param lastUpdated
         *        When the current default version of the type was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The description of the type.
         * </p>
         * 
         * @param description
         *        The description of the type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String defaultVersionId;

        private String typeArn;

        private Instant lastUpdated;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeSummary model) {
            type(model.type);
            typeName(model.typeName);
            defaultVersionId(model.defaultVersionId);
            typeArn(model.typeArn);
            lastUpdated(model.lastUpdated);
            description(model.description);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getDefaultVersionId() {
            return defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final String getTypeArn() {
            return typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public TypeSummary build() {
            return new TypeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
