/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ResourceSignalStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SignalResourceRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, SignalResourceRequest> {
    private final String stackName;
    private final String logicalResourceId;
    private final String uniqueId;
    private final String status;

    private SignalResourceRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.uniqueId = builder.uniqueId;
        this.status = builder.status;
    }

    public String stackName() {
        return this.stackName;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public ResourceSignalStatus status() {
        return ResourceSignalStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalResourceRequest)) {
            return false;
        }
        SignalResourceRequest other = (SignalResourceRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.uniqueId(), other.uniqueId()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        return ToString.builder((String)"SignalResourceRequest").add("StackName", (Object)this.stackName()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("UniqueId", (Object)this.uniqueId()).add("Status", (Object)this.statusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "LogicalResourceId": {
                return Optional.of(clazz.cast(this.logicalResourceId()));
            }
            case "UniqueId": {
                return Optional.of(clazz.cast(this.uniqueId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String logicalResourceId;
        private String uniqueId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalResourceRequest model) {
            this.stackName(model.stackName);
            this.logicalResourceId(model.logicalResourceId);
            this.uniqueId(model.uniqueId);
            this.status(model.status);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getUniqueId() {
            return this.uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSignalStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SignalResourceRequest build() {
            return new SignalResourceRequest(this);
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    CopyableBuilder<Builder, SignalResourceRequest> {
        public Builder stackName(String var1);

        public Builder logicalResourceId(String var1);

        public Builder uniqueId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceSignalStatus var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

