/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.Export;
import software.amazon.awssdk.services.cloudformation.model.ExportsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListExportsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListExportsResponse> {
    private final List<Export> exports;
    private final String nextToken;

    private ListExportsResponse(BuilderImpl builder) {
        super(builder);
        this.exports = builder.exports;
        this.nextToken = builder.nextToken;
    }

    public List<Export> exports() {
        return this.exports;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exports());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse)((Object)obj);
        return Objects.equals(this.exports(), other.exports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListExportsResponse").add("Exports", this.exports()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Exports": {
                return Optional.of(clazz.cast(this.exports()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<Export> exports;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            this.exports(model.exports);
            this.nextToken(model.nextToken);
        }

        public final Collection<Export.Builder> getExports() {
            return this.exports != null ? (Collection)this.exports.stream().map(Export::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exports(Collection<Export> exports) {
            this.exports = ExportsCopier.copy(exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Export ... exports) {
            this.exports(Arrays.asList(exports));
            return this;
        }

        public final void setExports(Collection<Export.BuilderImpl> exports) {
            this.exports = ExportsCopier.copyFromBuilder(exports);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, ListExportsResponse> {
        public Builder exports(Collection<Export> var1);

        public Builder exports(Export ... var1);

        public Builder nextToken(String var1);
    }
}

