/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.ParameterDeclaration;
import software.amazon.awssdk.services.cloudformation.model.ParameterDeclarationsCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.TransformsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetTemplateSummaryResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, GetTemplateSummaryResponse> {
    private final List<ParameterDeclaration> parameters;
    private final String description;
    private final List<String> capabilities;
    private final String capabilitiesReason;
    private final List<String> resourceTypes;
    private final String version;
    private final String metadata;
    private final List<String> declaredTransforms;

    private GetTemplateSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.resourceTypes = builder.resourceTypes;
        this.version = builder.version;
        this.metadata = builder.metadata;
        this.declaredTransforms = builder.declaredTransforms;
    }

    public List<ParameterDeclaration> parameters() {
        return this.parameters;
    }

    public String description() {
        return this.description;
    }

    public List<Capability> capabilities() {
        return TypeConverter.convert(this.capabilities, Capability::fromValue);
    }

    public List<String> capabilitiesStrings() {
        return this.capabilities;
    }

    public String capabilitiesReason() {
        return this.capabilitiesReason;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String version() {
        return this.version;
    }

    public String metadata() {
        return this.metadata;
    }

    public List<String> declaredTransforms() {
        return this.declaredTransforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.declaredTransforms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryResponse)) {
            return false;
        }
        GetTemplateSummaryResponse other = (GetTemplateSummaryResponse)((Object)obj);
        return Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.capabilitiesStrings(), other.capabilitiesStrings()) && Objects.equals(this.capabilitiesReason(), other.capabilitiesReason()) && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.declaredTransforms(), other.declaredTransforms());
    }

    public String toString() {
        return ToString.builder((String)"GetTemplateSummaryResponse").add("Parameters", this.parameters()).add("Description", (Object)this.description()).add("Capabilities", this.capabilitiesStrings()).add("CapabilitiesReason", (Object)this.capabilitiesReason()).add("ResourceTypes", this.resourceTypes()).add("Version", (Object)this.version()).add("Metadata", (Object)this.metadata()).add("DeclaredTransforms", this.declaredTransforms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Capabilities": {
                return Optional.of(clazz.cast(this.capabilitiesStrings()));
            }
            case "CapabilitiesReason": {
                return Optional.of(clazz.cast(this.capabilitiesReason()));
            }
            case "ResourceTypes": {
                return Optional.of(clazz.cast(this.resourceTypes()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
            case "DeclaredTransforms": {
                return Optional.of(clazz.cast(this.declaredTransforms()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<ParameterDeclaration> parameters;
        private String description;
        private List<String> capabilities;
        private String capabilitiesReason;
        private List<String> resourceTypes;
        private String version;
        private String metadata;
        private List<String> declaredTransforms;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryResponse model) {
            this.parameters(model.parameters);
            this.description(model.description);
            this.capabilities(model.capabilities);
            this.capabilitiesReason(model.capabilitiesReason);
            this.resourceTypes(model.resourceTypes);
            this.version(model.version);
            this.metadata(model.metadata);
            this.declaredTransforms(model.declaredTransforms);
        }

        public final Collection<ParameterDeclaration.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(ParameterDeclaration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<ParameterDeclaration> parameters) {
            this.parameters = ParameterDeclarationsCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterDeclaration ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<ParameterDeclaration.BuilderImpl> parameters) {
            this.parameters = ParameterDeclarationsCopier.copyFromBuilder(parameters);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final String getCapabilitiesReason() {
            return this.capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Collection<String> getDeclaredTransforms() {
            return this.declaredTransforms;
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String ... declaredTransforms) {
            this.declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        @Override
        public GetTemplateSummaryResponse build() {
            return new GetTemplateSummaryResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, GetTemplateSummaryResponse> {
        public Builder parameters(Collection<ParameterDeclaration> var1);

        public Builder parameters(ParameterDeclaration ... var1);

        public Builder description(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilitiesReason(String var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder version(String var1);

        public Builder metadata(String var1);

        public Builder declaredTransforms(Collection<String> var1);

        public Builder declaredTransforms(String ... var1);
    }
}

