/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.Change;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus;
import software.amazon.awssdk.services.cloudformation.model.ChangesCopier;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecutionStatus;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeChangeSetResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeChangeSetResponse> {
    private final String changeSetName;
    private final String changeSetId;
    private final String stackId;
    private final String stackName;
    private final String description;
    private final List<Parameter> parameters;
    private final Instant creationTime;
    private final String executionStatus;
    private final String status;
    private final String statusReason;
    private final List<String> notificationARNs;
    private final RollbackConfiguration rollbackConfiguration;
    private final List<String> capabilities;
    private final List<Tag> tags;
    private final List<Change> changes;
    private final String nextToken;

    private DescribeChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.changeSetName = builder.changeSetName;
        this.changeSetId = builder.changeSetId;
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.executionStatus = builder.executionStatus;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.notificationARNs = builder.notificationARNs;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.changes = builder.changes;
        this.nextToken = builder.nextToken;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String changeSetId() {
        return this.changeSetId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String description() {
        return this.description;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(this.executionStatus);
    }

    public String executionStatusString() {
        return this.executionStatus;
    }

    public ChangeSetStatus status() {
        return ChangeSetStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public RollbackConfiguration rollbackConfiguration() {
        return this.rollbackConfiguration;
    }

    public List<Capability> capabilities() {
        return TypeConverter.convert(this.capabilities, Capability::fromValue);
    }

    public List<String> capabilitiesStrings() {
        return this.capabilities;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<Change> changes() {
        return this.changes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.changes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetResponse)) {
            return false;
        }
        DescribeChangeSetResponse other = (DescribeChangeSetResponse)((Object)obj);
        return Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.executionStatusString(), other.executionStatusString()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.notificationARNs(), other.notificationARNs()) && Objects.equals(this.rollbackConfiguration(), other.rollbackConfiguration()) && Objects.equals(this.capabilitiesStrings(), other.capabilitiesStrings()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.changes(), other.changes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeChangeSetResponse").add("ChangeSetName", (Object)this.changeSetName()).add("ChangeSetId", (Object)this.changeSetId()).add("StackId", (Object)this.stackId()).add("StackName", (Object)this.stackName()).add("Description", (Object)this.description()).add("Parameters", this.parameters()).add("CreationTime", (Object)this.creationTime()).add("ExecutionStatus", (Object)this.executionStatusString()).add("Status", (Object)this.statusString()).add("StatusReason", (Object)this.statusReason()).add("NotificationARNs", this.notificationARNs()).add("RollbackConfiguration", (Object)this.rollbackConfiguration()).add("Capabilities", this.capabilitiesStrings()).add("Tags", this.tags()).add("Changes", this.changes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeSetName": {
                return Optional.of(clazz.cast(this.changeSetName()));
            }
            case "ChangeSetId": {
                return Optional.of(clazz.cast(this.changeSetId()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "ExecutionStatus": {
                return Optional.of(clazz.cast(this.executionStatusString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "NotificationARNs": {
                return Optional.of(clazz.cast(this.notificationARNs()));
            }
            case "RollbackConfiguration": {
                return Optional.of(clazz.cast(this.rollbackConfiguration()));
            }
            case "Capabilities": {
                return Optional.of(clazz.cast(this.capabilitiesStrings()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "Changes": {
                return Optional.of(clazz.cast(this.changes()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String changeSetName;
        private String changeSetId;
        private String stackId;
        private String stackName;
        private String description;
        private List<Parameter> parameters;
        private Instant creationTime;
        private String executionStatus;
        private String status;
        private String statusReason;
        private List<String> notificationARNs;
        private RollbackConfiguration rollbackConfiguration;
        private List<String> capabilities;
        private List<Tag> tags;
        private List<Change> changes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetResponse model) {
            this.changeSetName(model.changeSetName);
            this.changeSetId(model.changeSetId);
            this.stackId(model.stackId);
            this.stackName(model.stackName);
            this.description(model.description);
            this.parameters(model.parameters);
            this.creationTime(model.creationTime);
            this.executionStatus(model.executionStatus);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.notificationARNs(model.notificationARNs);
            this.rollbackConfiguration(model.rollbackConfiguration);
            this.capabilities(model.capabilities);
            this.tags(model.tags);
            this.changes(model.changes);
            this.nextToken(model.nextToken);
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus.toString());
            return this;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return this.rollbackConfiguration != null ? this.rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<Change.Builder> getChanges() {
            return this.changes != null ? (Collection)this.changes.stream().map(Change::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangesCopier.copyFromBuilder(changes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeChangeSetResponse build() {
            return new DescribeChangeSetResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, DescribeChangeSetResponse> {
        public Builder changeSetName(String var1);

        public Builder changeSetId(String var1);

        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder creationTime(Instant var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder status(String var1);

        public Builder status(ChangeSetStatus var1);

        public Builder statusReason(String var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder rollbackConfiguration(RollbackConfiguration var1);

        default public Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return this.rollbackConfiguration((RollbackConfiguration)((RollbackConfiguration.Builder)RollbackConfiguration.builder().apply(rollbackConfiguration)).build());
        }

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder changes(Collection<Change> var1);

        public Builder changes(Change ... var1);

        public Builder nextToken(String var1);
    }
}

