/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * CreateStackSetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateStackSetRequestMarshaller implements Marshaller<Request<CreateStackSetRequest>, CreateStackSetRequest> {

    public Request<CreateStackSetRequest> marshall(CreateStackSetRequest createStackSetRequest) {

        if (createStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateStackSetRequest> request = new DefaultRequest<CreateStackSetRequest>(createStackSetRequest,
                "CloudFormationClient");
        request.addParameter("Action", "CreateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(createStackSetRequest.stackSetName()));
        }

        if (createStackSetRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(createStackSetRequest.description()));
        }

        if (createStackSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString(createStackSetRequest.templateBody()));
        }

        if (createStackSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString(createStackSetRequest.templateURL()));
        }

        java.util.List<Parameter> parametersList = createStackSetRequest.parameters();

        if (parametersList != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;

                for (Parameter parametersListValue : parametersList) {

                    if (parametersListValue.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                                StringUtils.fromString(parametersListValue.parameterKey()));
                    }

                    if (parametersListValue.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                                StringUtils.fromString(parametersListValue.parameterValue()));
                    }

                    if (parametersListValue.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                                StringUtils.fromBoolean(parametersListValue.usePreviousValue()));
                    }
                    parametersListIndex++;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }

        java.util.List<String> capabilitiesList = createStackSetRequest.capabilitiesStrings();

        if (capabilitiesList != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;

                for (String capabilitiesListValue : capabilitiesList) {
                    if (capabilitiesListValue != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex,
                                StringUtils.fromString(capabilitiesListValue));
                    }
                    capabilitiesListIndex++;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }

        java.util.List<Tag> tagsList = createStackSetRequest.tags();

        if (tagsList != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;

                for (Tag tagsListValue : tagsList) {

                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.key()));
                    }

                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value",
                                StringUtils.fromString(tagsListValue.value()));
                    }
                    tagsListIndex++;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }

        request.addParameter("ClientRequestToken", IdempotentUtils.resolveString(createStackSetRequest.clientRequestToken()));

        return request;
    }

}
