/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateStackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateStackRequestMarshaller implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {

    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {

        if (createStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateStackRequest> request = new DefaultRequest<CreateStackRequest>(createStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(createStackRequest.stackName()));
        }

        if (createStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString(createStackRequest.templateBody()));
        }

        if (createStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString(createStackRequest.templateURL()));
        }

        java.util.List<Parameter> parametersList = createStackRequest.parameters();

        if (parametersList != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;

                for (Parameter parametersListValue : parametersList) {

                    if (parametersListValue.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey",
                                StringUtils.fromString(parametersListValue.parameterKey()));
                    }

                    if (parametersListValue.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue",
                                StringUtils.fromString(parametersListValue.parameterValue()));
                    }

                    if (parametersListValue.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue",
                                StringUtils.fromBoolean(parametersListValue.usePreviousValue()));
                    }
                    parametersListIndex++;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }

        if (createStackRequest.disableRollback() != null) {
            request.addParameter("DisableRollback", StringUtils.fromBoolean(createStackRequest.disableRollback()));
        }

        RollbackConfiguration rollbackConfiguration = createStackRequest.rollbackConfiguration();
        if (rollbackConfiguration != null) {

            java.util.List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();

            if (rollbackTriggersList != null) {
                if (!rollbackTriggersList.isEmpty()) {
                    int rollbackTriggersListIndex = 1;

                    for (RollbackTrigger rollbackTriggersListValue : rollbackTriggersList) {

                        if (rollbackTriggersListValue.arn() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                    + ".Arn", StringUtils.fromString(rollbackTriggersListValue.arn()));
                        }

                        if (rollbackTriggersListValue.type() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex
                                    + ".Type", StringUtils.fromString(rollbackTriggersListValue.type()));
                        }
                        rollbackTriggersListIndex++;
                    }
                } else {
                    request.addParameter("RollbackConfiguration.RollbackTriggers", "");
                }
            }

            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes",
                        StringUtils.fromInteger(rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }

        if (createStackRequest.timeoutInMinutes() != null) {
            request.addParameter("TimeoutInMinutes", StringUtils.fromInteger(createStackRequest.timeoutInMinutes()));
        }

        java.util.List<String> notificationARNsList = createStackRequest.notificationARNs();

        if (notificationARNsList != null) {
            if (!notificationARNsList.isEmpty()) {
                int notificationARNsListIndex = 1;

                for (String notificationARNsListValue : notificationARNsList) {
                    if (notificationARNsListValue != null) {
                        request.addParameter("NotificationARNs.member." + notificationARNsListIndex,
                                StringUtils.fromString(notificationARNsListValue));
                    }
                    notificationARNsListIndex++;
                }
            } else {
                request.addParameter("NotificationARNs", "");
            }
        }

        java.util.List<String> capabilitiesList = createStackRequest.capabilitiesStrings();

        if (capabilitiesList != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;

                for (String capabilitiesListValue : capabilitiesList) {
                    if (capabilitiesListValue != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex,
                                StringUtils.fromString(capabilitiesListValue));
                    }
                    capabilitiesListIndex++;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }

        java.util.List<String> resourceTypesList = createStackRequest.resourceTypes();

        if (resourceTypesList != null) {
            if (!resourceTypesList.isEmpty()) {
                int resourceTypesListIndex = 1;

                for (String resourceTypesListValue : resourceTypesList) {
                    if (resourceTypesListValue != null) {
                        request.addParameter("ResourceTypes.member." + resourceTypesListIndex,
                                StringUtils.fromString(resourceTypesListValue));
                    }
                    resourceTypesListIndex++;
                }
            } else {
                request.addParameter("ResourceTypes", "");
            }
        }

        if (createStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(createStackRequest.roleARN()));
        }

        if (createStackRequest.onFailureString() != null) {
            request.addParameter("OnFailure", StringUtils.fromString(createStackRequest.onFailureString()));
        }

        if (createStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString(createStackRequest.stackPolicyBody()));
        }

        if (createStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString(createStackRequest.stackPolicyURL()));
        }

        java.util.List<Tag> tagsList = createStackRequest.tags();

        if (tagsList != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;

                for (Tag tagsListValue : tagsList) {

                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.key()));
                    }

                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value",
                                StringUtils.fromString(tagsListValue.value()));
                    }
                    tagsListIndex++;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }

        if (createStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(createStackRequest.clientRequestToken()));
        }

        if (createStackRequest.enableTerminationProtection() != null) {
            request.addParameter("EnableTerminationProtection",
                    StringUtils.fromBoolean(createStackRequest.enableTerminationProtection()));
        }

        return request;
    }

}
