/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rollback trigger AWS CloudFormation monitors during creation and updating of stacks. If any of the alarms you
 * specify goes to ALERT state during the stack operation or within the specified monitoring period afterwards,
 * CloudFormation rolls back the entire stack operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RollbackTrigger implements ToCopyableBuilder<RollbackTrigger.Builder, RollbackTrigger> {
    private final String arn;

    private final String type;

    private RollbackTrigger(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rollback trigger.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rollback trigger.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The resource type of the rollback trigger. Currently, <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html"
     * >AWS::CloudWatch::Alarm</a> is the only supported resource type.
     * </p>
     * 
     * @return The resource type of the rollback trigger. Currently, <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html"
     *         >AWS::CloudWatch::Alarm</a> is the only supported resource type.
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackTrigger)) {
            return false;
        }
        RollbackTrigger other = (RollbackTrigger) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(type(), other.type());
    }

    @Override
    public String toString() {
        return ToString.builder("RollbackTrigger").add("Arn", arn()).add("Type", type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "Type":
            return Optional.of(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RollbackTrigger> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rollback trigger.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the rollback trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The resource type of the rollback trigger. Currently, <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html"
         * >AWS::CloudWatch::Alarm</a> is the only supported resource type.
         * </p>
         * 
         * @param type
         *        The resource type of the rollback trigger. Currently, <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html"
         *        >AWS::CloudWatch::Alarm</a> is the only supported resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackTrigger model) {
            arn(model.arn);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public RollbackTrigger build() {
            return new RollbackTrigger(this);
        }
    }
}
