/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ResourceChange</code> structure describes the resource and the action that AWS CloudFormation will perform
 * on it if you execute this change set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceChange implements ToCopyableBuilder<ResourceChange.Builder, ResourceChange> {
    private final String action;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final String replacement;

    private final List<String> scope;

    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    /**
     * <p>
     * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionString}.
     * </p>
     * 
     * @return The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     *         <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * @see ChangeAction
     */
    public ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionString}.
     * </p>
     * 
     * @return The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     *         <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * @see ChangeAction
     */
    public String actionString() {
        return action;
    }

    /**
     * <p>
     * The resource's logical ID, which is defined in the stack's template.
     * </p>
     * 
     * @return The resource's logical ID, which is defined in the stack's template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they
     * haven't been created.
     * </p>
     * 
     * @return The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because
     *         they haven't been created.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     * </p>
     * 
     * @return The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by creating a
     * new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property
     * in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field
     * is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is
     * <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the
     * <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.
     * </p>
     * <p>
     * If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code>
     * value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code>
     * has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacement} will
     * return {@link Replacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replacementString}.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
     *         creating a new one and deleting the old one. This value depends on the value of the
     *         <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
     *         example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
     *         <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If
     *         the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
     *         <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
     *         <p>
     *         If you have multiple changes with different <code>RequiresRecreation</code> values, the
     *         <code>Replacement</code> value depends on the change with the most impact. A
     *         <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
     *         <code>Conditionally</code>, and then <code>Never</code>.
     * @see Replacement
     */
    public Replacement replacement() {
        return Replacement.fromValue(replacement);
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by creating a
     * new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property
     * in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field
     * is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is
     * <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the
     * <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.
     * </p>
     * <p>
     * If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code>
     * value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code>
     * has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacement} will
     * return {@link Replacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replacementString}.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
     *         creating a new one and deleting the old one. This value depends on the value of the
     *         <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
     *         example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
     *         <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If
     *         the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
     *         <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
     *         <p>
     *         If you have multiple changes with different <code>RequiresRecreation</code> values, the
     *         <code>Replacement</code> value depends on the change with the most impact. A
     *         <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
     *         <code>Conditionally</code>, and then <code>Never</code>.
     * @see Replacement
     */
    public String replacementString() {
        return replacement;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
     * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as
     *         a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>
     *         .
     */
    public List<ResourceAttribute> scope() {
        return TypeConverter.convert(scope, ResourceAttribute::fromValue);
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
     * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as
     *         a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>
     *         .
     */
    public List<String> scopeStrings() {
        return scope;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
     * changes that AWS CloudFormation will make to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes
     *         the changes that AWS CloudFormation will make to the resource.
     */
    public List<ResourceChangeDetail> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionString());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(replacementString());
        hashCode = 31 * hashCode + Objects.hashCode(scopeStrings());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange) obj;
        return Objects.equals(actionString(), other.actionString())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(replacementString(), other.replacementString())
                && Objects.equals(scopeStrings(), other.scopeStrings()) && Objects.equals(details(), other.details());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceChange").add("Action", actionString()).add("LogicalResourceId", logicalResourceId())
                .add("PhysicalResourceId", physicalResourceId()).add("ResourceType", resourceType())
                .add("Replacement", replacementString()).add("Scope", scopeStrings()).add("Details", details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.of(clazz.cast(actionString()));
        case "LogicalResourceId":
            return Optional.of(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.of(clazz.cast(physicalResourceId()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceType()));
        case "Replacement":
            return Optional.of(clazz.cast(replacementString()));
        case "Scope":
            return Optional.of(clazz.cast(scopeStrings()));
        case "Details":
            return Optional.of(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceChange> {
        /**
         * <p>
         * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
         * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * </p>
         * 
         * @param action
         *        The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new
         *        resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
         * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * </p>
         * 
         * @param action
         *        The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new
         *        resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * The resource's logical ID, which is defined in the stack's template.
         * </p>
         * 
         * @param logicalResourceId
         *        The resource's logical ID, which is defined in the stack's template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because
         * they haven't been created.
         * </p>
         * 
         * @param physicalResourceId
         *        The resource's physical ID (resource name). Resources that you are adding don't have physical IDs
         *        because they haven't been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         * creating a new one and deleting the old one. This value depends on the value of the
         * <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example,
         * if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
         * <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code>
         * field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>,
         * <code>Replacement</code> is <code>Conditionally</code>.
         * </p>
         * <p>
         * If you have multiple changes with different <code>RequiresRecreation</code> values, the
         * <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code>
         * value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then
         * <code>Never</code>.
         * </p>
         * 
         * @param replacement
         *        For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         *        creating a new one and deleting the old one. This value depends on the value of the
         *        <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
         *        example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
         *        <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>.
         *        If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code>
         *        field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
         *        <p>
         *        If you have multiple changes with different <code>RequiresRecreation</code> values, the
         *        <code>Replacement</code> value depends on the change with the most impact. A
         *        <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
         *        <code>Conditionally</code>, and then <code>Never</code>.
         * @see Replacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(String replacement);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         * creating a new one and deleting the old one. This value depends on the value of the
         * <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example,
         * if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
         * <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code>
         * field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>,
         * <code>Replacement</code> is <code>Conditionally</code>.
         * </p>
         * <p>
         * If you have multiple changes with different <code>RequiresRecreation</code> values, the
         * <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code>
         * value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then
         * <code>Never</code>.
         * </p>
         * 
         * @param replacement
         *        For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         *        creating a new one and deleting the old one. This value depends on the value of the
         *        <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
         *        example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
         *        <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>.
         *        If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code>
         *        field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
         *        <p>
         *        If you have multiple changes with different <code>RequiresRecreation</code> values, the
         *        <code>Replacement</code> value depends on the change with the most impact. A
         *        <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
         *        <code>Conditionally</code>, and then <code>Never</code>.
         * @see Replacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(Replacement replacement);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Collection<String> scope);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String... scope);

        /**
         * <p>
         * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
         * changes that AWS CloudFormation will make to the resource.
         * </p>
         * 
         * @param details
         *        For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that
         *        describes the changes that AWS CloudFormation will make to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<ResourceChangeDetail> details);

        /**
         * <p>
         * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
         * changes that AWS CloudFormation will make to the resource.
         * </p>
         * 
         * @param details
         *        For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that
         *        describes the changes that AWS CloudFormation will make to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ResourceChangeDetail... details);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private String replacement;

        private List<String> scope;

        private List<ResourceChangeDetail> details;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            action(model.action);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceType(model.resourceType);
            replacement(model.replacement);
            scope(model.scope);
            details(model.details);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getReplacement() {
            return replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement.toString());
            return this;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public final Collection<String> getScope() {
            return scope;
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String... scope) {
            scope(Arrays.asList(scope));
            return this;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        public final Collection<ResourceChangeDetail.Builder> getDetails() {
            return details != null ? details.stream().map(ResourceChangeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail... details) {
            details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<ResourceChangeDetail.BuilderImpl> details) {
            this.details = ResourceChangeDetailsCopier.copyFromBuilder(details);
        }

        @Override
        public ResourceChange build() {
            return new ResourceChange(this);
        }
    }
}
