/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Output data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Output implements ToCopyableBuilder<Output.Builder, Output> {
    private final String outputKey;

    private final String outputValue;

    private final String description;

    private final String exportName;

    private Output(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
        this.exportName = builder.exportName;
    }

    /**
     * <p>
     * The key associated with the output.
     * </p>
     * 
     * @return The key associated with the output.
     */
    public String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The value associated with the output.
     * </p>
     * 
     * @return The value associated with the output.
     */
    public String outputValue() {
        return outputValue;
    }

    /**
     * <p>
     * User defined description associated with the output.
     * </p>
     * 
     * @return User defined description associated with the output.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the export associated with the output.
     * </p>
     * 
     * @return The name of the export associated with the output.
     */
    public String exportName() {
        return exportName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(outputValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(exportName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return Objects.equals(outputKey(), other.outputKey()) && Objects.equals(outputValue(), other.outputValue())
                && Objects.equals(description(), other.description()) && Objects.equals(exportName(), other.exportName());
    }

    @Override
    public String toString() {
        return ToString.builder("Output").add("OutputKey", outputKey()).add("OutputValue", outputValue())
                .add("Description", description()).add("ExportName", exportName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputKey":
            return Optional.of(clazz.cast(outputKey()));
        case "OutputValue":
            return Optional.of(clazz.cast(outputValue()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ExportName":
            return Optional.of(clazz.cast(exportName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Output> {
        /**
         * <p>
         * The key associated with the output.
         * </p>
         * 
         * @param outputKey
         *        The key associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The value associated with the output.
         * </p>
         * 
         * @param outputValue
         *        The value associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputValue(String outputValue);

        /**
         * <p>
         * User defined description associated with the output.
         * </p>
         * 
         * @param description
         *        User defined description associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the export associated with the output.
         * </p>
         * 
         * @param exportName
         *        The name of the export associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportName(String exportName);
    }

    static final class BuilderImpl implements Builder {
        private String outputKey;

        private String outputValue;

        private String description;

        private String exportName;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            outputKey(model.outputKey);
            outputValue(model.outputValue);
            description(model.description);
            exportName(model.exportName);
        }

        public final String getOutputKey() {
            return outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExportName() {
            return exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        @Override
        public Output build() {
            return new Output(this);
        }
    }
}
