/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for <a>GetTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTemplateResponse extends CloudFormationResponse implements
        ToCopyableBuilder<GetTemplateResponse.Builder, GetTemplateResponse> {
    private final String templateBody;

    private final List<String> stagesAvailable;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.stagesAvailable = builder.stagesAvailable;
    }

    /**
     * <p>
     * Structure containing the template body. (For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.)
     * </p>
     * <p>
     * AWS CloudFormation returns the same template that was used when the stack was created.
     * </p>
     * 
     * @return Structure containing the template body. (For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.)</p>
     *         <p>
     *         AWS CloudFormation returns the same template that was used when the stack was created.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code>
     * templates are always available. For change sets, the <code>Original</code> template is always available. After
     * AWS CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
     *         <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
     *         template is always available. After AWS CloudFormation finishes creating the change set, the
     *         <code>Processed</code> template becomes available.
     */
    public List<TemplateStage> stagesAvailable() {
        return TypeConverter.convert(stagesAvailable, TemplateStage::fromValue);
    }

    /**
     * <p>
     * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code>
     * templates are always available. For change sets, the <code>Original</code> template is always available. After
     * AWS CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
     *         <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
     *         template is always available. After AWS CloudFormation finishes creating the change set, the
     *         <code>Processed</code> template becomes available.
     */
    public List<String> stagesAvailableStrings() {
        return stagesAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(stagesAvailableStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse) obj;
        return Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(stagesAvailableStrings(), other.stagesAvailableStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("GetTemplateResponse").add("TemplateBody", templateBody())
                .add("StagesAvailable", stagesAvailableStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateBody":
            return Optional.of(clazz.cast(templateBody()));
        case "StagesAvailable":
            return Optional.of(clazz.cast(stagesAvailableStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, GetTemplateResponse> {
        /**
         * <p>
         * Structure containing the template body. (For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.)
         * </p>
         * <p>
         * AWS CloudFormation returns the same template that was used when the stack was created.
         * </p>
         * 
         * @param templateBody
         *        Structure containing the template body. (For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.)</p>
         *        <p>
         *        AWS CloudFormation returns the same template that was used when the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code>
         * template becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After AWS CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailable(Collection<String> stagesAvailable);

        /**
         * <p>
         * The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         * <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is
         * always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code>
         * template becomes available.
         * </p>
         * 
         * @param stagesAvailable
         *        The stage of the template that you can retrieve. For stacks, the <code>Original</code> and
         *        <code>Processed</code> templates are always available. For change sets, the <code>Original</code>
         *        template is always available. After AWS CloudFormation finishes creating the change set, the
         *        <code>Processed</code> template becomes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagesAvailable(String... stagesAvailable);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String templateBody;

        private List<String> stagesAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            templateBody(model.templateBody);
            stagesAvailable(model.stagesAvailable);
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final Collection<String> getStagesAvailable() {
            return stagesAvailable;
        }

        @Override
        public final Builder stagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(String... stagesAvailable) {
            stagesAvailable(Arrays.asList(stagesAvailable));
            return this;
        }

        public final void setStagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }
    }
}
