/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>DescribeStackResources</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackResourcesResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackResourcesResponse.Builder, DescribeStackResourcesResponse> {
    private final List<StackResource> stackResources;

    private DescribeStackResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.stackResources = builder.stackResources;
    }

    /**
     * <p>
     * A list of <code>StackResource</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>StackResource</code> structures.
     */
    public List<StackResource> stackResources() {
        return stackResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackResources());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesResponse)) {
            return false;
        }
        DescribeStackResourcesResponse other = (DescribeStackResourcesResponse) obj;
        return Objects.equals(stackResources(), other.stackResources());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStackResourcesResponse").add("StackResources", stackResources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResources":
            return Optional.of(clazz.cast(stackResources()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, DescribeStackResourcesResponse> {
        /**
         * <p>
         * A list of <code>StackResource</code> structures.
         * </p>
         * 
         * @param stackResources
         *        A list of <code>StackResource</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResources(Collection<StackResource> stackResources);

        /**
         * <p>
         * A list of <code>StackResource</code> structures.
         * </p>
         * 
         * @param stackResources
         *        A list of <code>StackResource</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResources(StackResource... stackResources);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackResource> stackResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesResponse model) {
            stackResources(model.stackResources);
        }

        public final Collection<StackResource.Builder> getStackResources() {
            return stackResources != null ? stackResources.stream().map(StackResource::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stackResources(Collection<StackResource> stackResources) {
            this.stackResources = StackResourcesCopier.copy(stackResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResources(StackResource... stackResources) {
            stackResources(Arrays.asList(stackResources));
            return this;
        }

        public final void setStackResources(Collection<StackResource.BuilderImpl> stackResources) {
            this.stackResources = StackResourcesCopier.copyFromBuilder(stackResources);
        }

        @Override
        public DescribeStackResourcesResponse build() {
            return new DescribeStackResourcesResponse(this);
        }
    }
}
