/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListChangeSetsRequestMarshaller
implements Marshaller<Request<ListChangeSetsRequest>, ListChangeSetsRequest> {
    public Request<ListChangeSetsRequest> marshall(ListChangeSetsRequest listChangeSetsRequest) {
        if (listChangeSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listChangeSetsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListChangeSets");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listChangeSetsRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)listChangeSetsRequest.stackName()));
        }
        if (listChangeSetsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listChangeSetsRequest.nextToken()));
        }
        return request;
    }
}

