/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateChangeSetRequestMarshaller
implements Marshaller<Request<CreateChangeSetRequest>, CreateChangeSetRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateChangeSetRequest> marshall(CreateChangeSetRequest createChangeSetRequest) {
        List<Tag> list;
        List<String> list2;
        List<String> resourceTypesList;
        List<String> capabilitiesList;
        List<Parameter> parametersList;
        if (createChangeSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createChangeSetRequest.stackName()));
        }
        if (createChangeSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createChangeSetRequest.templateBody()));
        }
        if (createChangeSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createChangeSetRequest.templateURL()));
        }
        if (createChangeSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)createChangeSetRequest.usePreviousTemplate()));
        }
        if ((parametersList = createChangeSetRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parameter : parametersList) {
                    if (parameter.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameter.parameterKey()));
                    }
                    if (parameter.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameter.parameterValue()));
                    }
                    if (parameter.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameter.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if ((capabilitiesList = createChangeSetRequest.capabilities()) != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;
                for (String string : capabilitiesList) {
                    if (string != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)string));
                    }
                    ++capabilitiesListIndex;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((resourceTypesList = createChangeSetRequest.resourceTypes()) != null) {
            if (!resourceTypesList.isEmpty()) {
                boolean bl = true;
                for (String string : resourceTypesList) {
                    void var6_12;
                    if (string != null) {
                        request.addParameter("ResourceTypes.member." + (int)var6_12, StringUtils.fromString((String)string));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("ResourceTypes", "");
            }
        }
        if (createChangeSetRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)createChangeSetRequest.roleARN()));
        }
        if ((list2 = createChangeSetRequest.notificationARNs()) != null) {
            if (!list2.isEmpty()) {
                boolean bl = true;
                for (String notificationARNsListValue : list2) {
                    void var7_18;
                    if (notificationARNsListValue != null) {
                        request.addParameter("NotificationARNs.member." + (int)var7_18, StringUtils.fromString((String)notificationARNsListValue));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("NotificationARNs", "");
            }
        }
        if ((list = createChangeSetRequest.tags()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list) {
                    void var8_24;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var8_24;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)createChangeSetRequest.changeSetName()));
        }
        if (createChangeSetRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createChangeSetRequest.clientToken()));
        }
        if (createChangeSetRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createChangeSetRequest.description()));
        }
        if (createChangeSetRequest.changeSetType() != null) {
            request.addParameter("ChangeSetType", StringUtils.fromString((String)createChangeSetRequest.changeSetType()));
        }
        return request;
    }
}

