/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field that AWS CloudFormation will change, such as the name of a resource's property, and whether the resource
 * will be recreated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTargetDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTargetDefinition.Builder, ResourceTargetDefinition> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceTargetDefinition::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceTargetDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REQUIRES_RECREATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceTargetDefinition::requiresRecreationAsString)).setter(setter(Builder::requiresRecreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresRecreation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, NAME_FIELD,
            REQUIRES_RECREATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String name;

    private final String requiresRecreation;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
    }

    /**
     * <p>
     * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
     * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResourceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return Indicates which resource attribute is triggering this update, such as a change in the resource
     *         attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * @see ResourceAttribute
     */
    public ResourceAttribute attribute() {
        return ResourceAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
     * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResourceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return Indicates which resource attribute is triggering this update, such as a change in the resource
     *         attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * @see ResourceAttribute
     */
    public String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
     * attributes, the value is null.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
     *         attributes, the value is null.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
     * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
     * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
     * update behavior for that <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     * >property</a> in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requiresRecreation} will return {@link RequiresRecreation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requiresRecreationAsString}.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
     *         property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>,
     *         or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation,
     *         see the update behavior for that <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >property</a> in the AWS CloudFormation User Guide.
     * @see RequiresRecreation
     */
    public RequiresRecreation requiresRecreation() {
        return RequiresRecreation.fromValue(requiresRecreation);
    }

    /**
     * <p>
     * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
     * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
     * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
     * update behavior for that <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     * >property</a> in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #requiresRecreation} will return {@link RequiresRecreation#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #requiresRecreationAsString}.
     * </p>
     * 
     * @return If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
     *         property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>,
     *         or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation,
     *         see the update behavior for that <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
     *         >property</a> in the AWS CloudFormation User Guide.
     * @see RequiresRecreation
     */
    public String requiresRecreationAsString() {
        return requiresRecreation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requiresRecreationAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(requiresRecreationAsString(), other.requiresRecreationAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ResourceTargetDefinition").add("Attribute", attributeAsString()).add("Name", name())
                .add("RequiresRecreation", requiresRecreationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RequiresRecreation":
            return Optional.ofNullable(clazz.cast(requiresRecreationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceTargetDefinition, T> g) {
        return obj -> g.apply((ResourceTargetDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTargetDefinition> {
        /**
         * <p>
         * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
         * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param attribute
         *        Indicates which resource attribute is triggering this update, such as a change in the resource
         *        attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * @see ResourceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * Indicates which resource attribute is triggering this update, such as a change in the resource attribute's
         * <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param attribute
         *        Indicates which resource attribute is triggering this update, such as a change in the resource
         *        attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * @see ResourceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceAttribute
         */
        Builder attribute(ResourceAttribute attribute);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other
         * attributes, the value is null.
         * </p>
         * 
         * @param name
         *        If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all
         *        other attributes, the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
         * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
         * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
         * update behavior for that <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >property</a> in the AWS CloudFormation User Guide.
         * </p>
         * 
         * @param requiresRecreation
         *        If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
         *        property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>
         *        , or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code>
         *        recreation, see the update behavior for that <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >property</a> in the AWS CloudFormation User Guide.
         * @see RequiresRecreation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(String requiresRecreation);

        /**
         * <p>
         * If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property
         * causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or
         * <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the
         * update behavior for that <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         * >property</a> in the AWS CloudFormation User Guide.
         * </p>
         * 
         * @param requiresRecreation
         *        If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this
         *        property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>
         *        , or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code>
         *        recreation, see the update behavior for that <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"
         *        >property</a> in the AWS CloudFormation User Guide.
         * @see RequiresRecreation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiresRecreation
         */
        Builder requiresRecreation(RequiresRecreation requiresRecreation);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String name;

        private String requiresRecreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            attribute(model.attribute);
            name(model.name);
            requiresRecreation(model.requiresRecreation);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRequiresRecreation() {
            return requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation.toString());
            return this;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        @Override
        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
