/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.StackSet;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.transform.ParameterUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.TagUnmarshaller;

public class StackSetUnmarshaller
implements Unmarshaller<StackSet, StaxUnmarshallerContext> {
    private static final StackSetUnmarshaller INSTANCE = new StackSetUnmarshaller();

    public StackSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        StackSet.Builder stackSet;
        block14: {
            stackSet = StackSet.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Parameter> parameters = null;
            ArrayList<String> capabilities = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    stackSet.parameters(parameters);
                    stackSet.capabilitiesWithStrings(capabilities);
                    stackSet.tags(tags);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("StackSetName", targetDepth)) {
                        stackSet.stackSetName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StackSetId", targetDepth)) {
                        stackSet.stackSetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        stackSet.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        stackSet.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TemplateBody", targetDepth)) {
                        stackSet.templateBody(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Parameters", targetDepth)) {
                        parameters = new ArrayList<Parameter>();
                        continue;
                    }
                    if (context.testExpression("Parameters/member", targetDepth)) {
                        parameters.add(ParameterUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Capabilities", targetDepth)) {
                        capabilities = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Capabilities/member", targetDepth)) {
                        capabilities.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tags/member", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            stackSet.parameters(parameters);
            stackSet.capabilitiesWithStrings(capabilities);
            stackSet.tags(tags);
        }
        return (StackSet)stackSet.build();
    }

    public static StackSetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

