/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;

public class ListImportsRequestMarshaller
implements Marshaller<Request<ListImportsRequest>, ListImportsRequest> {
    public Request<ListImportsRequest> marshall(ListImportsRequest listImportsRequest) {
        if (listImportsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listImportsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListImports");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listImportsRequest.exportName() != null) {
            request.addParameter("ExportName", StringConversion.fromString((String)listImportsRequest.exportName()));
        }
        if (listImportsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listImportsRequest.nextToken()));
        }
        return request;
    }
}

