/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.http.response.DefaultErrorResponseHandler;
import software.amazon.awssdk.awscore.http.response.StaxResponseHandler;
import software.amazon.awssdk.awscore.protocol.xml.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreatedButModifiedException;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.InsufficientCapabilitiesException;
import software.amazon.awssdk.services.cloudformation.model.InvalidChangeSetStatusException;
import software.amazon.awssdk.services.cloudformation.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudformation.model.LimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.NameAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationIdAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationInProgressException;
import software.amazon.awssdk.services.cloudformation.model.OperationNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotEmptyException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StaleRequestException;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.TokenAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListExportsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListImportsIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesIterable;
import software.amazon.awssdk.services.cloudformation.paginators.ListStacksIterable;
import software.amazon.awssdk.services.cloudformation.transform.AlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CancelUpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CancelUpdateStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ChangeSetNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ContinueUpdateRollbackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ContinueUpdateRollbackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreatedButModifiedExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeAccountLimitsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackEventsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackInstanceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetOperationResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStacksResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.EstimateTemplateCostRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.EstimateTemplateCostResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteChangeSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetStackPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateSummaryRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateSummaryResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.InsufficientCapabilitiesExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.InvalidChangeSetStatusExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.InvalidOperationExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.LimitExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListChangeSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListChangeSetsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListExportsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListImportsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationResultsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStacksResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.NameAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.OperationIdAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.OperationInProgressExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.OperationNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetStackPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SignalResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SignalResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StackInstanceNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StackSetNotEmptyExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StackSetNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StaleRequestExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StopStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StopStackSetOperationResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.TokenAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackSetResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateTerminationProtectionRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateTerminationProtectionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ValidateTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ValidateTemplateResponseUnmarshaller;

@SdkInternalApi
final class DefaultCloudFormationClient
implements CloudFormationClient {
    private final SyncClientHandler clientHandler;
    private final List<Unmarshaller<AwsServiceException, Node>> exceptionUnmarshallers;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFormationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.exceptionUnmarshallers = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "cloudformation";
    }

    @Override
    public CancelUpdateStackResponse cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CancelUpdateStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CancelUpdateStackResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)cancelUpdateStackRequest).withMarshaller((Marshaller)new CancelUpdateStackRequestMarshaller()));
    }

    @Override
    public ContinueUpdateRollbackResponse continueUpdateRollback(ContinueUpdateRollbackRequest continueUpdateRollbackRequest) throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ContinueUpdateRollbackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ContinueUpdateRollbackResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)continueUpdateRollbackRequest).withMarshaller((Marshaller)new ContinueUpdateRollbackRequestMarshaller()));
    }

    @Override
    public CreateChangeSetResponse createChangeSet(CreateChangeSetRequest createChangeSetRequest) throws AlreadyExistsException, InsufficientCapabilitiesException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createChangeSetRequest).withMarshaller((Marshaller)new CreateChangeSetRequestMarshaller()));
    }

    @Override
    public CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException, AlreadyExistsException, TokenAlreadyExistsException, InsufficientCapabilitiesException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateStackResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createStackRequest).withMarshaller((Marshaller)new CreateStackRequestMarshaller()));
    }

    @Override
    public CreateStackInstancesResponse createStackInstances(CreateStackInstancesRequest createStackInstancesRequest) throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateStackInstancesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateStackInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createStackInstancesRequest).withMarshaller((Marshaller)new CreateStackInstancesRequestMarshaller()));
    }

    @Override
    public CreateStackSetResponse createStackSet(CreateStackSetRequest createStackSetRequest) throws NameAlreadyExistsException, CreatedButModifiedException, LimitExceededException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateStackSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createStackSetRequest).withMarshaller((Marshaller)new CreateStackSetRequestMarshaller()));
    }

    @Override
    public DeleteChangeSetResponse deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest) throws InvalidChangeSetStatusException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteChangeSetRequest).withMarshaller((Marshaller)new DeleteChangeSetRequestMarshaller()));
    }

    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteStackResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteStackRequest).withMarshaller((Marshaller)new DeleteStackRequestMarshaller()));
    }

    @Override
    public DeleteStackInstancesResponse deleteStackInstances(DeleteStackInstancesRequest deleteStackInstancesRequest) throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteStackInstancesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteStackInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteStackInstancesRequest).withMarshaller((Marshaller)new DeleteStackInstancesRequestMarshaller()));
    }

    @Override
    public DeleteStackSetResponse deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) throws StackSetNotEmptyException, OperationInProgressException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteStackSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteStackSetRequest).withMarshaller((Marshaller)new DeleteStackSetRequestMarshaller()));
    }

    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeAccountLimitsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller()));
    }

    @Override
    public DescribeChangeSetResponse describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeChangeSetRequest).withMarshaller((Marshaller)new DescribeChangeSetRequestMarshaller()));
    }

    @Override
    public DescribeStackEventsResponse describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackEventsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeStackEventsRequest).withMarshaller((Marshaller)new DescribeStackEventsRequestMarshaller()));
    }

    @Override
    public DescribeStackEventsIterable describeStackEventsPaginator(DescribeStackEventsRequest describeStackEventsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new DescribeStackEventsIterable(this, this.applyPaginatorUserAgent(describeStackEventsRequest));
    }

    @Override
    public DescribeStackInstanceResponse describeStackInstance(DescribeStackInstanceRequest describeStackInstanceRequest) throws StackSetNotFoundException, StackInstanceNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackInstanceResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeStackInstanceRequest).withMarshaller((Marshaller)new DescribeStackInstanceRequestMarshaller()));
    }

    @Override
    public DescribeStackResourceResponse describeStackResource(DescribeStackResourceRequest describeStackResourceRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackResourceResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeStackResourceRequest).withMarshaller((Marshaller)new DescribeStackResourceRequestMarshaller()));
    }

    @Override
    public DescribeStackResourcesResponse describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackResourcesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeStackResourcesRequest).withMarshaller((Marshaller)new DescribeStackResourcesRequestMarshaller()));
    }

    @Override
    public DescribeStackSetResponse describeStackSet(DescribeStackSetRequest describeStackSetRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeStackSetRequest).withMarshaller((Marshaller)new DescribeStackSetRequestMarshaller()));
    }

    @Override
    public DescribeStackSetOperationResponse describeStackSetOperation(DescribeStackSetOperationRequest describeStackSetOperationRequest) throws StackSetNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStackSetOperationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStackSetOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeStackSetOperationRequest).withMarshaller((Marshaller)new DescribeStackSetOperationRequestMarshaller()));
    }

    @Override
    public DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DescribeStacksResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DescribeStacksResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)describeStacksRequest).withMarshaller((Marshaller)new DescribeStacksRequestMarshaller()));
    }

    @Override
    public DescribeStacksIterable describeStacksPaginator(DescribeStacksRequest describeStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new DescribeStacksIterable(this, this.applyPaginatorUserAgent(describeStacksRequest));
    }

    @Override
    public EstimateTemplateCostResponse estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new EstimateTemplateCostResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (EstimateTemplateCostResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)estimateTemplateCostRequest).withMarshaller((Marshaller)new EstimateTemplateCostRequestMarshaller()));
    }

    @Override
    public ExecuteChangeSetResponse executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest) throws InvalidChangeSetStatusException, ChangeSetNotFoundException, InsufficientCapabilitiesException, TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ExecuteChangeSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ExecuteChangeSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)executeChangeSetRequest).withMarshaller((Marshaller)new ExecuteChangeSetRequestMarshaller()));
    }

    @Override
    public GetStackPolicyResponse getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetStackPolicyResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetStackPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getStackPolicyRequest).withMarshaller((Marshaller)new GetStackPolicyRequestMarshaller()));
    }

    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest getTemplateRequest) throws ChangeSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetTemplateResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getTemplateRequest).withMarshaller((Marshaller)new GetTemplateRequestMarshaller()));
    }

    @Override
    public GetTemplateSummaryResponse getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetTemplateSummaryResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetTemplateSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getTemplateSummaryRequest).withMarshaller((Marshaller)new GetTemplateSummaryRequestMarshaller()));
    }

    @Override
    public ListChangeSetsResponse listChangeSets(ListChangeSetsRequest listChangeSetsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListChangeSetsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListChangeSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listChangeSetsRequest).withMarshaller((Marshaller)new ListChangeSetsRequestMarshaller()));
    }

    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListExportsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listExportsRequest).withMarshaller((Marshaller)new ListExportsRequestMarshaller()));
    }

    @Override
    public ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListExportsIterable(this, this.applyPaginatorUserAgent(listExportsRequest));
    }

    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListImportsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listImportsRequest).withMarshaller((Marshaller)new ListImportsRequestMarshaller()));
    }

    @Override
    public ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListImportsIterable(this, this.applyPaginatorUserAgent(listImportsRequest));
    }

    @Override
    public ListStackInstancesResponse listStackInstances(ListStackInstancesRequest listStackInstancesRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStackInstancesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStackInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listStackInstancesRequest).withMarshaller((Marshaller)new ListStackInstancesRequestMarshaller()));
    }

    @Override
    public ListStackResourcesResponse listStackResources(ListStackResourcesRequest listStackResourcesRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStackResourcesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStackResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listStackResourcesRequest).withMarshaller((Marshaller)new ListStackResourcesRequestMarshaller()));
    }

    @Override
    public ListStackResourcesIterable listStackResourcesPaginator(ListStackResourcesRequest listStackResourcesRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListStackResourcesIterable(this, this.applyPaginatorUserAgent(listStackResourcesRequest));
    }

    @Override
    public ListStackSetOperationResultsResponse listStackSetOperationResults(ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) throws StackSetNotFoundException, OperationNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStackSetOperationResultsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStackSetOperationResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listStackSetOperationResultsRequest).withMarshaller((Marshaller)new ListStackSetOperationResultsRequestMarshaller()));
    }

    @Override
    public ListStackSetOperationsResponse listStackSetOperations(ListStackSetOperationsRequest listStackSetOperationsRequest) throws StackSetNotFoundException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStackSetOperationsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStackSetOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listStackSetOperationsRequest).withMarshaller((Marshaller)new ListStackSetOperationsRequestMarshaller()));
    }

    @Override
    public ListStackSetsResponse listStackSets(ListStackSetsRequest listStackSetsRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStackSetsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStackSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listStackSetsRequest).withMarshaller((Marshaller)new ListStackSetsRequestMarshaller()));
    }

    @Override
    public ListStacksResponse listStacks(ListStacksRequest listStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStacksResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListStacksResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listStacksRequest).withMarshaller((Marshaller)new ListStacksRequestMarshaller()));
    }

    @Override
    public ListStacksIterable listStacksPaginator(ListStacksRequest listStacksRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        return new ListStacksIterable(this, this.applyPaginatorUserAgent(listStacksRequest));
    }

    @Override
    public SetStackPolicyResponse setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetStackPolicyResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetStackPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setStackPolicyRequest).withMarshaller((Marshaller)new SetStackPolicyRequestMarshaller()));
    }

    @Override
    public SignalResourceResponse signalResource(SignalResourceRequest signalResourceRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SignalResourceResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SignalResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)signalResourceRequest).withMarshaller((Marshaller)new SignalResourceRequestMarshaller()));
    }

    @Override
    public StopStackSetOperationResponse stopStackSetOperation(StopStackSetOperationRequest stopStackSetOperationRequest) throws StackSetNotFoundException, OperationNotFoundException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new StopStackSetOperationResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (StopStackSetOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)stopStackSetOperationRequest).withMarshaller((Marshaller)new StopStackSetOperationRequestMarshaller()));
    }

    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws InsufficientCapabilitiesException, TokenAlreadyExistsException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateStackResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (UpdateStackResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)updateStackRequest).withMarshaller((Marshaller)new UpdateStackRequestMarshaller()));
    }

    @Override
    public UpdateStackSetResponse updateStackSet(UpdateStackSetRequest updateStackSetRequest) throws StackSetNotFoundException, OperationInProgressException, OperationIdAlreadyExistsException, StaleRequestException, InvalidOperationException, AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateStackSetResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (UpdateStackSetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)updateStackSetRequest).withMarshaller((Marshaller)new UpdateStackSetRequestMarshaller()));
    }

    @Override
    public UpdateTerminationProtectionResponse updateTerminationProtection(UpdateTerminationProtectionRequest updateTerminationProtectionRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateTerminationProtectionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (UpdateTerminationProtectionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)updateTerminationProtectionRequest).withMarshaller((Marshaller)new UpdateTerminationProtectionRequestMarshaller()));
    }

    @Override
    public ValidateTemplateResponse validateTemplate(ValidateTemplateRequest validateTemplateRequest) throws AwsServiceException, SdkClientException, CloudFormationException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ValidateTemplateResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ValidateTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)validateTemplateRequest).withMarshaller((Marshaller)new ValidateTemplateRequestMarshaller()));
    }

    private List<Unmarshaller<AwsServiceException, Node>> init() {
        ArrayList<Unmarshaller<AwsServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AwsServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidChangeSetStatusExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StackSetNotEmptyExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidOperationExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TokenAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new ChangeSetNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new NameAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new LimitExceededExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new OperationNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StackSetNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InsufficientCapabilitiesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StackInstanceNotFoundExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new AlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new OperationInProgressExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StaleRequestExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new OperationIdAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new CreatedButModifiedExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StandardErrorUnmarshaller(CloudFormationException.class));
        return unmarshallers;
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudFormationRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-11").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFormationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

