/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SignalResourceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SignalResourceRequestMarshaller implements Marshaller<Request<SignalResourceRequest>, SignalResourceRequest> {

    public Request<SignalResourceRequest> marshall(SignalResourceRequest signalResourceRequest) {

        if (signalResourceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SignalResourceRequest> request = new DefaultRequest<SignalResourceRequest>(signalResourceRequest,
                "CloudFormationClient");
        request.addParameter("Action", "SignalResource");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (signalResourceRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString(signalResourceRequest.stackName()));
        }

        if (signalResourceRequest.logicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringConversion.fromString(signalResourceRequest.logicalResourceId()));
        }

        if (signalResourceRequest.uniqueId() != null) {
            request.addParameter("UniqueId", StringConversion.fromString(signalResourceRequest.uniqueId()));
        }

        if (signalResourceRequest.statusAsString() != null) {
            request.addParameter("Status", StringConversion.fromString(signalResourceRequest.statusAsString()));
        }

        return request;
    }

}
