/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ListStackInstancesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListStackInstancesResponseUnmarshaller implements Unmarshaller<ListStackInstancesResponse, StaxUnmarshallerContext> {

    public ListStackInstancesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListStackInstancesResponse.Builder listStackInstancesResponse = ListStackInstancesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<StackInstanceSummary> summaries = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listStackInstancesResponse.summaries(summaries);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Summaries", targetDepth)) {
                    summaries = new ArrayList<StackInstanceSummary>();
                    continue;
                }

                if (context.testExpression("Summaries/member", targetDepth)) {
                    summaries.add(StackInstanceSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listStackInstancesResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listStackInstancesResponse.summaries(summaries);
                    break;
                }
            }
        }
        return listStackInstancesResponse.build();
    }

    private static final ListStackInstancesResponseUnmarshaller INSTANCE = new ListStackInstancesResponseUnmarshaller();

    public static ListStackInstancesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
