/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DescribeStackEventsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeStackEventsResponseUnmarshaller implements
        Unmarshaller<DescribeStackEventsResponse, StaxUnmarshallerContext> {

    public DescribeStackEventsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeStackEventsResponse.Builder describeStackEventsResponse = DescribeStackEventsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<StackEvent> stackEvents = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeStackEventsResponse.stackEvents(stackEvents);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("StackEvents", targetDepth)) {
                    stackEvents = new ArrayList<StackEvent>();
                    continue;
                }

                if (context.testExpression("StackEvents/member", targetDepth)) {
                    stackEvents.add(StackEventUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    describeStackEventsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeStackEventsResponse.stackEvents(stackEvents);
                    break;
                }
            }
        }
        return describeStackEventsResponse.build();
    }

    private static final DescribeStackEventsResponseUnmarshaller INSTANCE = new DescribeStackEventsResponseUnmarshaller();

    public static DescribeStackEventsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
