/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * DeleteStackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteStackRequestMarshaller implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {

    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {

        if (deleteStackRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<DeleteStackRequest> request = new DefaultRequest<DeleteStackRequest>(deleteStackRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (deleteStackRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString(deleteStackRequest.stackName()));
        }

        if (deleteStackRequest.retainResources().isEmpty()
                && !(deleteStackRequest.retainResources() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("RetainResources", "");
        } else if (!deleteStackRequest.retainResources().isEmpty()
                && !(deleteStackRequest.retainResources() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> retainResourcesList = deleteStackRequest.retainResources();
            int retainResourcesListIndex = 1;

            for (String retainResourcesListValue : retainResourcesList) {
                if (retainResourcesListValue != null) {
                    request.addParameter("RetainResources.member." + retainResourcesListIndex,
                            StringConversion.fromString(retainResourcesListValue));
                }
                retainResourcesListIndex++;
            }
        }

        if (deleteStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString(deleteStackRequest.roleARN()));
        }

        if (deleteStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString(deleteStackRequest.clientRequestToken()));
        }

        return request;
    }

}
