/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DeleteChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteChangeSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DeleteChangeSetRequest.Builder, DeleteChangeSetRequest> {
    private final String changeSetName;

    private final String stackName;

    private DeleteChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.changeSetName = builder.changeSetName;
        this.stackName = builder.stackName;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the change set that you want to delete.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the change set that you want to delete.
     */
    public String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * If you specified the name of a change set to delete, specify the stack name or ID (ARN) that is associated with
     * it.
     * </p>
     * 
     * @return If you specified the name of a change set to delete, specify the stack name or ID (ARN) that is
     *         associated with it.
     */
    public String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChangeSetRequest)) {
            return false;
        }
        DeleteChangeSetRequest other = (DeleteChangeSetRequest) obj;
        return Objects.equals(changeSetName(), other.changeSetName()) && Objects.equals(stackName(), other.stackName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteChangeSetRequest").add("ChangeSetName", changeSetName()).add("StackName", stackName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, DeleteChangeSetRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the change set that you want to delete.
         * </p>
         * 
         * @param changeSetName
         *        The name or Amazon Resource Name (ARN) of the change set that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * If you specified the name of a change set to delete, specify the stack name or ID (ARN) that is associated
         * with it.
         * </p>
         * 
         * @param stackName
         *        If you specified the name of a change set to delete, specify the stack name or ID (ARN) that is
         *        associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String changeSetName;

        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChangeSetRequest model) {
            super(model);
            changeSetName(model.changeSetName);
            stackName(model.stackName);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteChangeSetRequest build() {
            return new DeleteChangeSetRequest(this);
        }
    }
}
