/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDirectoryResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, CreateDirectoryResponse> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(CreateDirectoryResponse.getter(CreateDirectoryResponse::directoryArn)).setter(CreateDirectoryResponse.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDirectoryResponse.getter(CreateDirectoryResponse::name)).setter(CreateDirectoryResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectIdentifier").getter(CreateDirectoryResponse.getter(CreateDirectoryResponse::objectIdentifier)).setter(CreateDirectoryResponse.setter(Builder::objectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()}).build();
    private static final SdkField<String> APPLIED_SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppliedSchemaArn").getter(CreateDirectoryResponse.getter(CreateDirectoryResponse::appliedSchemaArn)).setter(CreateDirectoryResponse.setter(Builder::appliedSchemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedSchemaArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, NAME_FIELD, OBJECT_IDENTIFIER_FIELD, APPLIED_SCHEMA_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDirectoryResponse.memberNameToFieldInitializer();
    private final String directoryArn;
    private final String name;
    private final String objectIdentifier;
    private final String appliedSchemaArn;

    private CreateDirectoryResponse(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.name = builder.name;
        this.objectIdentifier = builder.objectIdentifier;
        this.appliedSchemaArn = builder.appliedSchemaArn;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final String name() {
        return this.name;
    }

    public final String objectIdentifier() {
        return this.objectIdentifier;
    }

    public final String appliedSchemaArn() {
        return this.appliedSchemaArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedSchemaArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryResponse)) {
            return false;
        }
        CreateDirectoryResponse other = (CreateDirectoryResponse)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier()) && Objects.equals(this.appliedSchemaArn(), other.appliedSchemaArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDirectoryResponse").add("DirectoryArn", (Object)this.directoryArn()).add("Name", (Object)this.name()).add("ObjectIdentifier", (Object)this.objectIdentifier()).add("AppliedSchemaArn", (Object)this.appliedSchemaArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
            case "AppliedSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.appliedSchemaArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DirectoryArn", DIRECTORY_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ObjectIdentifier", OBJECT_IDENTIFIER_FIELD);
        map.put("AppliedSchemaArn", APPLIED_SCHEMA_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectoryResponse, T> g) {
        return obj -> g.apply((CreateDirectoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private String directoryArn;
        private String name;
        private String objectIdentifier;
        private String appliedSchemaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryResponse model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.name(model.name);
            this.objectIdentifier(model.objectIdentifier);
            this.appliedSchemaArn(model.appliedSchemaArn);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final String getAppliedSchemaArn() {
            return this.appliedSchemaArn;
        }

        public final void setAppliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
        }

        @Override
        public final Builder appliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
            return this;
        }

        @Override
        public CreateDirectoryResponse build() {
            return new CreateDirectoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDirectoryResponse> {
        public Builder directoryArn(String var1);

        public Builder name(String var1);

        public Builder objectIdentifier(String var1);

        public Builder appliedSchemaArn(String var1);
    }
}

