/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachment;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListIndexResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListIndexResponse> {
    private static final SdkField<List<IndexAttachment>> INDEX_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IndexAttachments").getter(BatchListIndexResponse.getter(BatchListIndexResponse::indexAttachments)).setter(BatchListIndexResponse.setter(Builder::indexAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IndexAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchListIndexResponse.getter(BatchListIndexResponse::nextToken)).setter(BatchListIndexResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchListIndexResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<IndexAttachment> indexAttachments;
    private final String nextToken;

    private BatchListIndexResponse(BuilderImpl builder) {
        this.indexAttachments = builder.indexAttachments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIndexAttachments() {
        return this.indexAttachments != null && !(this.indexAttachments instanceof SdkAutoConstructList);
    }

    public final List<IndexAttachment> indexAttachments() {
        return this.indexAttachments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndexAttachments() ? this.indexAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIndexResponse)) {
            return false;
        }
        BatchListIndexResponse other = (BatchListIndexResponse)obj;
        return this.hasIndexAttachments() == other.hasIndexAttachments() && Objects.equals(this.indexAttachments(), other.indexAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchListIndexResponse").add("IndexAttachments", this.hasIndexAttachments() ? this.indexAttachments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexAttachments": {
                return Optional.ofNullable(clazz.cast(this.indexAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexAttachments", INDEX_ATTACHMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchListIndexResponse, T> g) {
        return obj -> g.apply((BatchListIndexResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IndexAttachment> indexAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIndexResponse model) {
            this.indexAttachments(model.indexAttachments);
            this.nextToken(model.nextToken);
        }

        public final List<IndexAttachment.Builder> getIndexAttachments() {
            List<IndexAttachment.Builder> result = IndexAttachmentListCopier.copyToBuilder(this.indexAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexAttachments(Collection<IndexAttachment.BuilderImpl> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copyFromBuilder(indexAttachments);
        }

        @Override
        public final Builder indexAttachments(Collection<IndexAttachment> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copy(indexAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(IndexAttachment ... indexAttachments) {
            this.indexAttachments(Arrays.asList(indexAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(Consumer<IndexAttachment.Builder> ... indexAttachments) {
            this.indexAttachments(Stream.of(indexAttachments).map(c -> (IndexAttachment)((IndexAttachment.Builder)IndexAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public BatchListIndexResponse build() {
            return new BatchListIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListIndexResponse> {
        public Builder indexAttachments(Collection<IndexAttachment> var1);

        public Builder indexAttachments(IndexAttachment ... var1);

        public Builder indexAttachments(Consumer<IndexAttachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

