/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse;

public class ListObjectParentPathsPublisher
implements SdkPublisher<ListObjectParentPathsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListObjectParentPathsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectParentPathsPublisher(CloudDirectoryAsyncClient client, ListObjectParentPathsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectParentPathsPublisher(CloudDirectoryAsyncClient client, ListObjectParentPathsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectParentPathsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectParentPathsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListObjectParentPathsResponseFetcher
    implements AsyncPageFetcher<ListObjectParentPathsResponse> {
        private ListObjectParentPathsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectParentPathsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListObjectParentPathsResponse> nextPage(ListObjectParentPathsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectParentPathsPublisher.this.client.listObjectParentPaths(ListObjectParentPathsPublisher.this.firstRequest);
            }
            return ListObjectParentPathsPublisher.this.client.listObjectParentPaths((ListObjectParentPathsRequest)((Object)ListObjectParentPathsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

