/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse;

public class ListObjectParentsIterable
implements SdkIterable<ListObjectParentsResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectParentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectParentsIterable(CloudDirectoryClient client, ListObjectParentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListObjectParentsResponseFetcher();
    }

    public Iterator<ListObjectParentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListObjectParentsResponseFetcher
    implements SyncPageFetcher<ListObjectParentsResponse> {
        private ListObjectParentsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectParentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObjectParentsResponse nextPage(ListObjectParentsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectParentsIterable.this.client.listObjectParents(ListObjectParentsIterable.this.firstRequest);
            }
            return ListObjectParentsIterable.this.client.listObjectParents((ListObjectParentsRequest)((Object)ListObjectParentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

