/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;

public class LookupPolicyIterable
implements SdkIterable<LookupPolicyResponse> {
    private final CloudDirectoryClient client;
    private final LookupPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public LookupPolicyIterable(CloudDirectoryClient client, LookupPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new LookupPolicyResponseFetcher();
    }

    public Iterator<LookupPolicyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class LookupPolicyResponseFetcher
    implements SyncPageFetcher<LookupPolicyResponse> {
        private LookupPolicyResponseFetcher() {
        }

        public boolean hasNextPage(LookupPolicyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public LookupPolicyResponse nextPage(LookupPolicyResponse previousPage) {
            if (previousPage == null) {
                return LookupPolicyIterable.this.client.lookupPolicy(LookupPolicyIterable.this.firstRequest);
            }
            return LookupPolicyIterable.this.client.lookupPolicy((LookupPolicyRequest)((Object)LookupPolicyIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

