/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeAppliedSchemaRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpgradeAppliedSchemaRequest> {
    private static final SdkField<String> PUBLISHED_SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishedSchemaArn").getter(UpgradeAppliedSchemaRequest.getter(UpgradeAppliedSchemaRequest::publishedSchemaArn)).setter(UpgradeAppliedSchemaRequest.setter(Builder::publishedSchemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedSchemaArn").build()}).build();
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(UpgradeAppliedSchemaRequest.getter(UpgradeAppliedSchemaRequest::directoryArn)).setter(UpgradeAppliedSchemaRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(UpgradeAppliedSchemaRequest.getter(UpgradeAppliedSchemaRequest::dryRun)).setter(UpgradeAppliedSchemaRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISHED_SCHEMA_ARN_FIELD, DIRECTORY_ARN_FIELD, DRY_RUN_FIELD));
    private final String publishedSchemaArn;
    private final String directoryArn;
    private final Boolean dryRun;

    private UpgradeAppliedSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.publishedSchemaArn = builder.publishedSchemaArn;
        this.directoryArn = builder.directoryArn;
        this.dryRun = builder.dryRun;
    }

    public final String publishedSchemaArn() {
        return this.publishedSchemaArn;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.publishedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeAppliedSchemaRequest)) {
            return false;
        }
        UpgradeAppliedSchemaRequest other = (UpgradeAppliedSchemaRequest)((Object)obj);
        return Objects.equals(this.publishedSchemaArn(), other.publishedSchemaArn()) && Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"UpgradeAppliedSchemaRequest").add("PublishedSchemaArn", (Object)this.publishedSchemaArn()).add("DirectoryArn", (Object)this.directoryArn()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublishedSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.publishedSchemaArn()));
            }
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeAppliedSchemaRequest, T> g) {
        return obj -> g.apply((UpgradeAppliedSchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String publishedSchemaArn;
        private String directoryArn;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeAppliedSchemaRequest model) {
            super(model);
            this.publishedSchemaArn(model.publishedSchemaArn);
            this.directoryArn(model.directoryArn);
            this.dryRun(model.dryRun);
        }

        public final String getPublishedSchemaArn() {
            return this.publishedSchemaArn;
        }

        public final void setPublishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
        }

        @Override
        @Transient
        public final Builder publishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
            return this;
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        @Transient
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        @Transient
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpgradeAppliedSchemaRequest build() {
            return new UpgradeAppliedSchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpgradeAppliedSchemaRequest> {
        public Builder publishedSchemaArn(String var1);

        public Builder directoryArn(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

