/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.ArnsCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedSchemaArnsResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListManagedSchemaArnsResponse> {
    private static final SdkField<List<String>> SCHEMA_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SchemaArns").getter(ListManagedSchemaArnsResponse.getter(ListManagedSchemaArnsResponse::schemaArns)).setter(ListManagedSchemaArnsResponse.setter(Builder::schemaArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListManagedSchemaArnsResponse.getter(ListManagedSchemaArnsResponse::nextToken)).setter(ListManagedSchemaArnsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> schemaArns;
    private final String nextToken;

    private ListManagedSchemaArnsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaArns = builder.schemaArns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSchemaArns() {
        return this.schemaArns != null && !(this.schemaArns instanceof SdkAutoConstructList);
    }

    public final List<String> schemaArns() {
        return this.schemaArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaArns() ? this.schemaArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedSchemaArnsResponse)) {
            return false;
        }
        ListManagedSchemaArnsResponse other = (ListManagedSchemaArnsResponse)((Object)obj);
        return this.hasSchemaArns() == other.hasSchemaArns() && Objects.equals(this.schemaArns(), other.schemaArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedSchemaArnsResponse").add("SchemaArns", this.hasSchemaArns() ? this.schemaArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArns": {
                return Optional.ofNullable(clazz.cast(this.schemaArns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListManagedSchemaArnsResponse, T> g) {
        return obj -> g.apply((ListManagedSchemaArnsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<String> schemaArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedSchemaArnsResponse model) {
            super(model);
            this.schemaArns(model.schemaArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getSchemaArns() {
            if (this.schemaArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.schemaArns;
        }

        public final void setSchemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
        }

        @Override
        @Transient
        public final Builder schemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder schemaArns(String ... schemaArns) {
            this.schemaArns(Arrays.asList(schemaArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListManagedSchemaArnsResponse build() {
            return new ListManagedSchemaArnsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedSchemaArnsResponse> {
        public Builder schemaArns(Collection<String> var1);

        public Builder schemaArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

