/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListIncomingTypedLinksResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListIncomingTypedLinksResponse> {
    private static final SdkField<List<TypedLinkSpecifier>> LINK_SPECIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkSpecifiers").getter(BatchListIncomingTypedLinksResponse.getter(BatchListIncomingTypedLinksResponse::linkSpecifiers)).setter(BatchListIncomingTypedLinksResponse.setter(Builder::linkSpecifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkSpecifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypedLinkSpecifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchListIncomingTypedLinksResponse.getter(BatchListIncomingTypedLinksResponse::nextToken)).setter(BatchListIncomingTypedLinksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_SPECIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TypedLinkSpecifier> linkSpecifiers;
    private final String nextToken;

    private BatchListIncomingTypedLinksResponse(BuilderImpl builder) {
        this.linkSpecifiers = builder.linkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLinkSpecifiers() {
        return this.linkSpecifiers != null && !(this.linkSpecifiers instanceof SdkAutoConstructList);
    }

    public final List<TypedLinkSpecifier> linkSpecifiers() {
        return this.linkSpecifiers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkSpecifiers() ? this.linkSpecifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIncomingTypedLinksResponse)) {
            return false;
        }
        BatchListIncomingTypedLinksResponse other = (BatchListIncomingTypedLinksResponse)obj;
        return this.hasLinkSpecifiers() == other.hasLinkSpecifiers() && Objects.equals(this.linkSpecifiers(), other.linkSpecifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchListIncomingTypedLinksResponse").add("LinkSpecifiers", this.hasLinkSpecifiers() ? this.linkSpecifiers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkSpecifiers": {
                return Optional.ofNullable(clazz.cast(this.linkSpecifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListIncomingTypedLinksResponse, T> g) {
        return obj -> g.apply((BatchListIncomingTypedLinksResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TypedLinkSpecifier> linkSpecifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIncomingTypedLinksResponse model) {
            this.linkSpecifiers(model.linkSpecifiers);
            this.nextToken(model.nextToken);
        }

        public final List<TypedLinkSpecifier.Builder> getLinkSpecifiers() {
            List<TypedLinkSpecifier.Builder> result = TypedLinkSpecifierListCopier.copyToBuilder(this.linkSpecifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinkSpecifiers(Collection<TypedLinkSpecifier.BuilderImpl> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copyFromBuilder(linkSpecifiers);
        }

        @Override
        @Transient
        public final Builder linkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copy(linkSpecifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder linkSpecifiers(TypedLinkSpecifier ... linkSpecifiers) {
            this.linkSpecifiers(Arrays.asList(linkSpecifiers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... linkSpecifiers) {
            this.linkSpecifiers(Stream.of(linkSpecifiers).map(c -> (TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public BatchListIncomingTypedLinksResponse build() {
            return new BatchListIncomingTypedLinksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListIncomingTypedLinksResponse> {
        public Builder linkSpecifiers(Collection<TypedLinkSpecifier> var1);

        public Builder linkSpecifiers(TypedLinkSpecifier ... var1);

        public Builder linkSpecifiers(Consumer<TypedLinkSpecifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

