/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reference that identifies an object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectReference implements SdkPojo, Serializable, ToCopyableBuilder<ObjectReference.Builder, ObjectReference> {
    private static final SdkField<String> SELECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Selector").getter(getter(ObjectReference::selector)).setter(setter(Builder::selector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String selector;

    private ObjectReference(BuilderImpl builder) {
        this.selector = builder.selector;
    }

    /**
     * <p>
     * A path selector supports easy selection of an object by the parent/child links leading to it from the directory
     * root. Use the link names from each parent/child link to construct the path. Path selectors start with a slash (/)
     * and link names are separated by slashes. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html"
     * >Access Objects</a>. You can identify an object in one of the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud Directory. When
     * creating objects, the system will provide you with the identifier of the created object. An object’s identifier
     * is immutable and no two objects will ever share the same object identifier. To identify an object with
     * ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>/some/path</i> - Identifies the object based on path
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>#SomeBatchReference</i> - Identifies the object in a batch call
     * </p>
     * </li>
     * </ul>
     * 
     * @return A path selector supports easy selection of an object by the parent/child links leading to it from the
     *         directory root. Use the link names from each parent/child link to construct the path. Path selectors
     *         start with a slash (/) and link names are separated by slashes. For more information about paths, see <a
     *         href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html"
     *         >Access Objects</a>. You can identify an object in one of the following ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud Directory.
     *         When creating objects, the system will provide you with the identifier of the created object. An object’s
     *         identifier is immutable and no two objects will ever share the same object identifier. To identify an
     *         object with ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>/some/path</i> - Identifies the object based on path
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>#SomeBatchReference</i> - Identifies the object in a batch call
     *         </p>
     *         </li>
     */
    public final String selector() {
        return selector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectReference)) {
            return false;
        }
        ObjectReference other = (ObjectReference) obj;
        return Objects.equals(selector(), other.selector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectReference").add("Selector", selector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Selector":
            return Optional.ofNullable(clazz.cast(selector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectReference, T> g) {
        return obj -> g.apply((ObjectReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectReference> {
        /**
         * <p>
         * A path selector supports easy selection of an object by the parent/child links leading to it from the
         * directory root. Use the link names from each parent/child link to construct the path. Path selectors start
         * with a slash (/) and link names are separated by slashes. For more information about paths, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html"
         * >Access Objects</a>. You can identify an object in one of the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud Directory. When
         * creating objects, the system will provide you with the identifier of the created object. An object’s
         * identifier is immutable and no two objects will ever share the same object identifier. To identify an object
         * with ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>/some/path</i> - Identifies the object based on path
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>#SomeBatchReference</i> - Identifies the object in a batch call
         * </p>
         * </li>
         * </ul>
         * 
         * @param selector
         *        A path selector supports easy selection of an object by the parent/child links leading to it from the
         *        directory root. Use the link names from each parent/child link to construct the path. Path selectors
         *        start with a slash (/) and link names are separated by slashes. For more information about paths, see
         *        <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html"
         *        >Access Objects</a>. You can identify an object in one of the following ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>$ObjectIdentifier</i> - An object identifier is an opaque string provided by Amazon Cloud
         *        Directory. When creating objects, the system will provide you with the identifier of the created
         *        object. An object’s identifier is immutable and no two objects will ever share the same object
         *        identifier. To identify an object with ObjectIdentifier, the ObjectIdentifier must be wrapped in
         *        double quotes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>/some/path</i> - Identifies the object based on path
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>#SomeBatchReference</i> - Identifies the object in a batch call
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selector(String selector);
    }

    static final class BuilderImpl implements Builder {
        private String selector;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectReference model) {
            selector(model.selector);
        }

        public final String getSelector() {
            return selector;
        }

        public final void setSelector(String selector) {
            this.selector = selector;
        }

        @Override
        @Transient
        public final Builder selector(String selector) {
            this.selector = selector;
            return this;
        }

        @Override
        public ObjectReference build() {
            return new ObjectReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
