/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The facet attribute reference that specifies the attribute definition that contains the attribute facet name and
 * attribute name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FacetAttributeReference implements SdkPojo, Serializable,
        ToCopyableBuilder<FacetAttributeReference.Builder, FacetAttributeReference> {
    private static final SdkField<String> TARGET_FACET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetFacetName").getter(getter(FacetAttributeReference::targetFacetName))
            .setter(setter(Builder::targetFacetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetFacetName").build()).build();

    private static final SdkField<String> TARGET_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAttributeName").getter(getter(FacetAttributeReference::targetAttributeName))
            .setter(setter(Builder::targetAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAttributeName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FACET_NAME_FIELD,
            TARGET_ATTRIBUTE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetFacetName;

    private final String targetAttributeName;

    private FacetAttributeReference(BuilderImpl builder) {
        this.targetFacetName = builder.targetFacetName;
        this.targetAttributeName = builder.targetAttributeName;
    }

    /**
     * <p>
     * The target facet name that is associated with the facet reference. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     * >Attribute References</a> for more information.
     * </p>
     * 
     * @return The target facet name that is associated with the facet reference. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     *         >Attribute References</a> for more information.
     */
    public final String targetFacetName() {
        return targetFacetName;
    }

    /**
     * <p>
     * The target attribute name that is associated with the facet reference. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     * >Attribute References</a> for more information.
     * </p>
     * 
     * @return The target attribute name that is associated with the facet reference. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
     *         >Attribute References</a> for more information.
     */
    public final String targetAttributeName() {
        return targetAttributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetFacetName());
        hashCode = 31 * hashCode + Objects.hashCode(targetAttributeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeReference)) {
            return false;
        }
        FacetAttributeReference other = (FacetAttributeReference) obj;
        return Objects.equals(targetFacetName(), other.targetFacetName())
                && Objects.equals(targetAttributeName(), other.targetAttributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FacetAttributeReference").add("TargetFacetName", targetFacetName())
                .add("TargetAttributeName", targetAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetFacetName":
            return Optional.ofNullable(clazz.cast(targetFacetName()));
        case "TargetAttributeName":
            return Optional.ofNullable(clazz.cast(targetAttributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FacetAttributeReference, T> g) {
        return obj -> g.apply((FacetAttributeReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FacetAttributeReference> {
        /**
         * <p>
         * The target facet name that is associated with the facet reference. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         * >Attribute References</a> for more information.
         * </p>
         * 
         * @param targetFacetName
         *        The target facet name that is associated with the facet reference. See <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         *        >Attribute References</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFacetName(String targetFacetName);

        /**
         * <p>
         * The target attribute name that is associated with the facet reference. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         * >Attribute References</a> for more information.
         * </p>
         * 
         * @param targetAttributeName
         *        The target attribute name that is associated with the facet reference. See <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html"
         *        >Attribute References</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAttributeName(String targetAttributeName);
    }

    static final class BuilderImpl implements Builder {
        private String targetFacetName;

        private String targetAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttributeReference model) {
            targetFacetName(model.targetFacetName);
            targetAttributeName(model.targetAttributeName);
        }

        public final String getTargetFacetName() {
            return targetFacetName;
        }

        public final void setTargetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
        }

        @Override
        @Transient
        public final Builder targetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
            return this;
        }

        public final String getTargetAttributeName() {
            return targetAttributeName;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        @Override
        @Transient
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        @Override
        public FacetAttributeReference build() {
            return new FacetAttributeReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
