/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFacetRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<CreateFacetRequest.Builder, CreateFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(CreateFacetRequest::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFacetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<FacetAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<FacetAttribute>> builder(MarshallingType.LIST)
            .memberName("Attributes")
            .getter(getter(CreateFacetRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FacetAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(FacetAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectType").getter(getter(CreateFacetRequest::objectTypeAsString)).setter(setter(Builder::objectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()).build();

    private static final SdkField<String> FACET_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FacetStyle").getter(getter(CreateFacetRequest::facetStyleAsString)).setter(setter(Builder::facetStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, NAME_FIELD,
            ATTRIBUTES_FIELD, OBJECT_TYPE_FIELD, FACET_STYLE_FIELD));

    private final String schemaArn;

    private final String name;

    private final List<FacetAttribute> attributes;

    private final String objectType;

    private final String facetStyle;

    private CreateFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.objectType = builder.objectType;
        this.facetStyle = builder.facetStyle;
    }

    /**
     * <p>
     * The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the <a>Facet</a>, which is unique for a given schema.
     * </p>
     * 
     * @return The name of the <a>Facet</a>, which is unique for a given schema.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes that are associated with the <a>Facet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attributes that are associated with the <a>Facet</a>.
     */
    public final List<FacetAttribute> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Node: Can have multiple children but one parent.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Leaf node: Cannot have children but can have multiple parents.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Index: Can be created with the Index API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Node: Can have multiple children but one parent.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Leaf node: Cannot have children but can have multiple parents.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     *         >Policies</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Index: Can be created with the Index API.
     *         </p>
     *         </li>
     * @see ObjectType
     */
    public final ObjectType objectType() {
        return ObjectType.fromValue(objectType);
    }

    /**
     * <p>
     * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Node: Can have multiple children but one parent.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Leaf node: Cannot have children but can have multiple parents.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * Index: Can be created with the Index API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return Specifies whether a given object created from this facet is of type node, leaf node, policy or index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Node: Can have multiple children but one parent.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Leaf node: Cannot have children but can have multiple parents.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Policy: Allows you to store a policy document and policy type. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     *         >Policies</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         Index: Can be created with the Index API.
     *         </p>
     *         </li>
     * @see ObjectType
     */
    public final String objectTypeAsString() {
        return objectType;
    }

    /**
     * <p>
     * There are two different styles that you can define on any given facet, <code>Static</code> and
     * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
     * attributes can be defined during data plane operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #facetStyle} will
     * return {@link FacetStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #facetStyleAsString}.
     * </p>
     * 
     * @return There are two different styles that you can define on any given facet, <code>Static</code> and
     *         <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
     *         facets, attributes can be defined during data plane operations.
     * @see FacetStyle
     */
    public final FacetStyle facetStyle() {
        return FacetStyle.fromValue(facetStyle);
    }

    /**
     * <p>
     * There are two different styles that you can define on any given facet, <code>Static</code> and
     * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
     * attributes can be defined during data plane operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #facetStyle} will
     * return {@link FacetStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #facetStyleAsString}.
     * </p>
     * 
     * @return There are two different styles that you can define on any given facet, <code>Static</code> and
     *         <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
     *         facets, attributes can be defined during data plane operations.
     * @see FacetStyle
     */
    public final String facetStyleAsString() {
        return facetStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(facetStyleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFacetRequest)) {
            return false;
        }
        CreateFacetRequest other = (CreateFacetRequest) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(name(), other.name())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(objectTypeAsString(), other.objectTypeAsString())
                && Objects.equals(facetStyleAsString(), other.facetStyleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFacetRequest").add("SchemaArn", schemaArn()).add("Name", name())
                .add("Attributes", hasAttributes() ? attributes() : null).add("ObjectType", objectTypeAsString())
                .add("FacetStyle", facetStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ObjectType":
            return Optional.ofNullable(clazz.cast(objectTypeAsString()));
        case "FacetStyle":
            return Optional.ofNullable(clazz.cast(facetStyleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFacetRequest, T> g) {
        return obj -> g.apply((CreateFacetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFacetRequest> {
        /**
         * <p>
         * The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param schemaArn
         *        The schema ARN in which the new <a>Facet</a> will be created. For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the <a>Facet</a>, which is unique for a given schema.
         * </p>
         * 
         * @param name
         *        The name of the <a>Facet</a>, which is unique for a given schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The attributes that are associated with the <a>Facet</a>.
         * </p>
         * 
         * @param attributes
         *        The attributes that are associated with the <a>Facet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<FacetAttribute> attributes);

        /**
         * <p>
         * The attributes that are associated with the <a>Facet</a>.
         * </p>
         * 
         * @param attributes
         *        The attributes that are associated with the <a>Facet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(FacetAttribute... attributes);

        /**
         * <p>
         * The attributes that are associated with the <a>Facet</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FacetAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<FacetAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FacetAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<FacetAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<FacetAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<FacetAttribute>)
         */
        Builder attributes(Consumer<FacetAttribute.Builder>... attributes);

        /**
         * <p>
         * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Node: Can have multiple children but one parent.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Leaf node: Cannot have children but can have multiple parents.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Index: Can be created with the Index API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param objectType
         *        Specifies whether a given object created from this facet is of type node, leaf node, policy or
         *        index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Node: Can have multiple children but one parent.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Leaf node: Cannot have children but can have multiple parents.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Index: Can be created with the Index API.
         *        </p>
         *        </li>
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(String objectType);

        /**
         * <p>
         * Specifies whether a given object created from this facet is of type node, leaf node, policy or index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Node: Can have multiple children but one parent.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Leaf node: Cannot have children but can have multiple parents.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * Index: Can be created with the Index API.
         * </p>
         * </li>
         * </ul>
         * 
         * @param objectType
         *        Specifies whether a given object created from this facet is of type node, leaf node, policy or
         *        index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Node: Can have multiple children but one parent.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Leaf node: Cannot have children but can have multiple parents.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Policy: Allows you to store a policy document and policy type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        Index: Can be created with the Index API.
         *        </p>
         *        </li>
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(ObjectType objectType);

        /**
         * <p>
         * There are two different styles that you can define on any given facet, <code>Static</code> and
         * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
         * attributes can be defined during data plane operations.
         * </p>
         * 
         * @param facetStyle
         *        There are two different styles that you can define on any given facet, <code>Static</code> and
         *        <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
         *        facets, attributes can be defined during data plane operations.
         * @see FacetStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FacetStyle
         */
        Builder facetStyle(String facetStyle);

        /**
         * <p>
         * There are two different styles that you can define on any given facet, <code>Static</code> and
         * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
         * attributes can be defined during data plane operations.
         * </p>
         * 
         * @param facetStyle
         *        There are two different styles that you can define on any given facet, <code>Static</code> and
         *        <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
         *        facets, attributes can be defined during data plane operations.
         * @see FacetStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FacetStyle
         */
        Builder facetStyle(FacetStyle facetStyle);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String schemaArn;

        private String name;

        private List<FacetAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private String objectType;

        private String facetStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFacetRequest model) {
            super(model);
            schemaArn(model.schemaArn);
            name(model.name);
            attributes(model.attributes);
            objectType(model.objectType);
            facetStyle(model.facetStyle);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        @Transient
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FacetAttribute.Builder> getAttributes() {
            List<FacetAttribute.Builder> result = FacetAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<FacetAttribute.BuilderImpl> attributes) {
            this.attributes = FacetAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(FacetAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<FacetAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> FacetAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getObjectType() {
            return objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        @Transient
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        @Transient
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        public final String getFacetStyle() {
            return facetStyle;
        }

        public final void setFacetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
        }

        @Override
        @Transient
        public final Builder facetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
            return this;
        }

        @Override
        @Transient
        public final Builder facetStyle(FacetStyle facetStyle) {
            this.facetStyle(facetStyle == null ? null : facetStyle.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFacetRequest build() {
            return new CreateFacetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
