/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchWrite</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchWriteOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchWriteOperation.Builder, BatchWriteOperation> {
    private static final SdkField<BatchCreateObject> CREATE_OBJECT_FIELD = SdkField
            .<BatchCreateObject> builder(MarshallingType.SDK_POJO).memberName("CreateObject")
            .getter(getter(BatchWriteOperation::createObject)).setter(setter(Builder::createObject))
            .constructor(BatchCreateObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateObject").build()).build();

    private static final SdkField<BatchAttachObject> ATTACH_OBJECT_FIELD = SdkField
            .<BatchAttachObject> builder(MarshallingType.SDK_POJO).memberName("AttachObject")
            .getter(getter(BatchWriteOperation::attachObject)).setter(setter(Builder::attachObject))
            .constructor(BatchAttachObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachObject").build()).build();

    private static final SdkField<BatchDetachObject> DETACH_OBJECT_FIELD = SdkField
            .<BatchDetachObject> builder(MarshallingType.SDK_POJO).memberName("DetachObject")
            .getter(getter(BatchWriteOperation::detachObject)).setter(setter(Builder::detachObject))
            .constructor(BatchDetachObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachObject").build()).build();

    private static final SdkField<BatchUpdateObjectAttributes> UPDATE_OBJECT_ATTRIBUTES_FIELD = SdkField
            .<BatchUpdateObjectAttributes> builder(MarshallingType.SDK_POJO).memberName("UpdateObjectAttributes")
            .getter(getter(BatchWriteOperation::updateObjectAttributes)).setter(setter(Builder::updateObjectAttributes))
            .constructor(BatchUpdateObjectAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateObjectAttributes").build())
            .build();

    private static final SdkField<BatchDeleteObject> DELETE_OBJECT_FIELD = SdkField
            .<BatchDeleteObject> builder(MarshallingType.SDK_POJO).memberName("DeleteObject")
            .getter(getter(BatchWriteOperation::deleteObject)).setter(setter(Builder::deleteObject))
            .constructor(BatchDeleteObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteObject").build()).build();

    private static final SdkField<BatchAddFacetToObject> ADD_FACET_TO_OBJECT_FIELD = SdkField
            .<BatchAddFacetToObject> builder(MarshallingType.SDK_POJO).memberName("AddFacetToObject")
            .getter(getter(BatchWriteOperation::addFacetToObject)).setter(setter(Builder::addFacetToObject))
            .constructor(BatchAddFacetToObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddFacetToObject").build()).build();

    private static final SdkField<BatchRemoveFacetFromObject> REMOVE_FACET_FROM_OBJECT_FIELD = SdkField
            .<BatchRemoveFacetFromObject> builder(MarshallingType.SDK_POJO).memberName("RemoveFacetFromObject")
            .getter(getter(BatchWriteOperation::removeFacetFromObject)).setter(setter(Builder::removeFacetFromObject))
            .constructor(BatchRemoveFacetFromObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveFacetFromObject").build())
            .build();

    private static final SdkField<BatchAttachPolicy> ATTACH_POLICY_FIELD = SdkField
            .<BatchAttachPolicy> builder(MarshallingType.SDK_POJO).memberName("AttachPolicy")
            .getter(getter(BatchWriteOperation::attachPolicy)).setter(setter(Builder::attachPolicy))
            .constructor(BatchAttachPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachPolicy").build()).build();

    private static final SdkField<BatchDetachPolicy> DETACH_POLICY_FIELD = SdkField
            .<BatchDetachPolicy> builder(MarshallingType.SDK_POJO).memberName("DetachPolicy")
            .getter(getter(BatchWriteOperation::detachPolicy)).setter(setter(Builder::detachPolicy))
            .constructor(BatchDetachPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachPolicy").build()).build();

    private static final SdkField<BatchCreateIndex> CREATE_INDEX_FIELD = SdkField
            .<BatchCreateIndex> builder(MarshallingType.SDK_POJO).memberName("CreateIndex")
            .getter(getter(BatchWriteOperation::createIndex)).setter(setter(Builder::createIndex))
            .constructor(BatchCreateIndex::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateIndex").build()).build();

    private static final SdkField<BatchAttachToIndex> ATTACH_TO_INDEX_FIELD = SdkField
            .<BatchAttachToIndex> builder(MarshallingType.SDK_POJO).memberName("AttachToIndex")
            .getter(getter(BatchWriteOperation::attachToIndex)).setter(setter(Builder::attachToIndex))
            .constructor(BatchAttachToIndex::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachToIndex").build()).build();

    private static final SdkField<BatchDetachFromIndex> DETACH_FROM_INDEX_FIELD = SdkField
            .<BatchDetachFromIndex> builder(MarshallingType.SDK_POJO).memberName("DetachFromIndex")
            .getter(getter(BatchWriteOperation::detachFromIndex)).setter(setter(Builder::detachFromIndex))
            .constructor(BatchDetachFromIndex::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachFromIndex").build()).build();

    private static final SdkField<BatchAttachTypedLink> ATTACH_TYPED_LINK_FIELD = SdkField
            .<BatchAttachTypedLink> builder(MarshallingType.SDK_POJO).memberName("AttachTypedLink")
            .getter(getter(BatchWriteOperation::attachTypedLink)).setter(setter(Builder::attachTypedLink))
            .constructor(BatchAttachTypedLink::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTypedLink").build()).build();

    private static final SdkField<BatchDetachTypedLink> DETACH_TYPED_LINK_FIELD = SdkField
            .<BatchDetachTypedLink> builder(MarshallingType.SDK_POJO).memberName("DetachTypedLink")
            .getter(getter(BatchWriteOperation::detachTypedLink)).setter(setter(Builder::detachTypedLink))
            .constructor(BatchDetachTypedLink::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachTypedLink").build()).build();

    private static final SdkField<BatchUpdateLinkAttributes> UPDATE_LINK_ATTRIBUTES_FIELD = SdkField
            .<BatchUpdateLinkAttributes> builder(MarshallingType.SDK_POJO).memberName("UpdateLinkAttributes")
            .getter(getter(BatchWriteOperation::updateLinkAttributes)).setter(setter(Builder::updateLinkAttributes))
            .constructor(BatchUpdateLinkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateLinkAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_OBJECT_FIELD,
            ATTACH_OBJECT_FIELD, DETACH_OBJECT_FIELD, UPDATE_OBJECT_ATTRIBUTES_FIELD, DELETE_OBJECT_FIELD,
            ADD_FACET_TO_OBJECT_FIELD, REMOVE_FACET_FROM_OBJECT_FIELD, ATTACH_POLICY_FIELD, DETACH_POLICY_FIELD,
            CREATE_INDEX_FIELD, ATTACH_TO_INDEX_FIELD, DETACH_FROM_INDEX_FIELD, ATTACH_TYPED_LINK_FIELD, DETACH_TYPED_LINK_FIELD,
            UPDATE_LINK_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchCreateObject createObject;

    private final BatchAttachObject attachObject;

    private final BatchDetachObject detachObject;

    private final BatchUpdateObjectAttributes updateObjectAttributes;

    private final BatchDeleteObject deleteObject;

    private final BatchAddFacetToObject addFacetToObject;

    private final BatchRemoveFacetFromObject removeFacetFromObject;

    private final BatchAttachPolicy attachPolicy;

    private final BatchDetachPolicy detachPolicy;

    private final BatchCreateIndex createIndex;

    private final BatchAttachToIndex attachToIndex;

    private final BatchDetachFromIndex detachFromIndex;

    private final BatchAttachTypedLink attachTypedLink;

    private final BatchDetachTypedLink detachTypedLink;

    private final BatchUpdateLinkAttributes updateLinkAttributes;

    private BatchWriteOperation(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
        this.attachPolicy = builder.attachPolicy;
        this.detachPolicy = builder.detachPolicy;
        this.createIndex = builder.createIndex;
        this.attachToIndex = builder.attachToIndex;
        this.detachFromIndex = builder.detachFromIndex;
        this.attachTypedLink = builder.attachTypedLink;
        this.detachTypedLink = builder.detachTypedLink;
        this.updateLinkAttributes = builder.updateLinkAttributes;
    }

    /**
     * <p>
     * Creates an object.
     * </p>
     * 
     * @return Creates an object.
     */
    public final BatchCreateObject createObject() {
        return createObject;
    }

    /**
     * <p>
     * Attaches an object to a <a>Directory</a>.
     * </p>
     * 
     * @return Attaches an object to a <a>Directory</a>.
     */
    public final BatchAttachObject attachObject() {
        return attachObject;
    }

    /**
     * <p>
     * Detaches an object from a <a>Directory</a>.
     * </p>
     * 
     * @return Detaches an object from a <a>Directory</a>.
     */
    public final BatchDetachObject detachObject() {
        return detachObject;
    }

    /**
     * <p>
     * Updates a given object's attributes.
     * </p>
     * 
     * @return Updates a given object's attributes.
     */
    public final BatchUpdateObjectAttributes updateObjectAttributes() {
        return updateObjectAttributes;
    }

    /**
     * <p>
     * Deletes an object in a <a>Directory</a>.
     * </p>
     * 
     * @return Deletes an object in a <a>Directory</a>.
     */
    public final BatchDeleteObject deleteObject() {
        return deleteObject;
    }

    /**
     * <p>
     * A batch operation that adds a facet to an object.
     * </p>
     * 
     * @return A batch operation that adds a facet to an object.
     */
    public final BatchAddFacetToObject addFacetToObject() {
        return addFacetToObject;
    }

    /**
     * <p>
     * A batch operation that removes a facet from an object.
     * </p>
     * 
     * @return A batch operation that removes a facet from an object.
     */
    public final BatchRemoveFacetFromObject removeFacetFromObject() {
        return removeFacetFromObject;
    }

    /**
     * <p>
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     * </p>
     * 
     * @return Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     */
    public final BatchAttachPolicy attachPolicy() {
        return attachPolicy;
    }

    /**
     * <p>
     * Detaches a policy from a <a>Directory</a>.
     * </p>
     * 
     * @return Detaches a policy from a <a>Directory</a>.
     */
    public final BatchDetachPolicy detachPolicy() {
        return detachPolicy;
    }

    /**
     * <p>
     * Creates an index object. See <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
     * search</a> for more information.
     * </p>
     * 
     * @return Creates an index object. See <a
     *         href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
     *         search</a> for more information.
     */
    public final BatchCreateIndex createIndex() {
        return createIndex;
    }

    /**
     * <p>
     * Attaches the specified object to the specified index.
     * </p>
     * 
     * @return Attaches the specified object to the specified index.
     */
    public final BatchAttachToIndex attachToIndex() {
        return attachToIndex;
    }

    /**
     * <p>
     * Detaches the specified object from the specified index.
     * </p>
     * 
     * @return Detaches the specified object from the specified index.
     */
    public final BatchDetachFromIndex detachFromIndex() {
        return detachFromIndex;
    }

    /**
     * <p>
     * Attaches a typed link to a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Attaches a typed link to a specified source and target object. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchAttachTypedLink attachTypedLink() {
        return attachTypedLink;
    }

    /**
     * <p>
     * Detaches a typed link from a specified source and target object. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Detaches a typed link from a specified source and target object. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchDetachTypedLink detachTypedLink() {
        return detachTypedLink;
    }

    /**
     * <p>
     * Updates a given object's attributes.
     * </p>
     * 
     * @return Updates a given object's attributes.
     */
    public final BatchUpdateLinkAttributes updateLinkAttributes() {
        return updateLinkAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createObject());
        hashCode = 31 * hashCode + Objects.hashCode(attachObject());
        hashCode = 31 * hashCode + Objects.hashCode(detachObject());
        hashCode = 31 * hashCode + Objects.hashCode(updateObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(deleteObject());
        hashCode = 31 * hashCode + Objects.hashCode(addFacetToObject());
        hashCode = 31 * hashCode + Objects.hashCode(removeFacetFromObject());
        hashCode = 31 * hashCode + Objects.hashCode(attachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(detachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(createIndex());
        hashCode = 31 * hashCode + Objects.hashCode(attachToIndex());
        hashCode = 31 * hashCode + Objects.hashCode(detachFromIndex());
        hashCode = 31 * hashCode + Objects.hashCode(attachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(detachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(updateLinkAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperation)) {
            return false;
        }
        BatchWriteOperation other = (BatchWriteOperation) obj;
        return Objects.equals(createObject(), other.createObject()) && Objects.equals(attachObject(), other.attachObject())
                && Objects.equals(detachObject(), other.detachObject())
                && Objects.equals(updateObjectAttributes(), other.updateObjectAttributes())
                && Objects.equals(deleteObject(), other.deleteObject())
                && Objects.equals(addFacetToObject(), other.addFacetToObject())
                && Objects.equals(removeFacetFromObject(), other.removeFacetFromObject())
                && Objects.equals(attachPolicy(), other.attachPolicy()) && Objects.equals(detachPolicy(), other.detachPolicy())
                && Objects.equals(createIndex(), other.createIndex()) && Objects.equals(attachToIndex(), other.attachToIndex())
                && Objects.equals(detachFromIndex(), other.detachFromIndex())
                && Objects.equals(attachTypedLink(), other.attachTypedLink())
                && Objects.equals(detachTypedLink(), other.detachTypedLink())
                && Objects.equals(updateLinkAttributes(), other.updateLinkAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchWriteOperation").add("CreateObject", createObject()).add("AttachObject", attachObject())
                .add("DetachObject", detachObject()).add("UpdateObjectAttributes", updateObjectAttributes())
                .add("DeleteObject", deleteObject()).add("AddFacetToObject", addFacetToObject())
                .add("RemoveFacetFromObject", removeFacetFromObject()).add("AttachPolicy", attachPolicy())
                .add("DetachPolicy", detachPolicy()).add("CreateIndex", createIndex()).add("AttachToIndex", attachToIndex())
                .add("DetachFromIndex", detachFromIndex()).add("AttachTypedLink", attachTypedLink())
                .add("DetachTypedLink", detachTypedLink()).add("UpdateLinkAttributes", updateLinkAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateObject":
            return Optional.ofNullable(clazz.cast(createObject()));
        case "AttachObject":
            return Optional.ofNullable(clazz.cast(attachObject()));
        case "DetachObject":
            return Optional.ofNullable(clazz.cast(detachObject()));
        case "UpdateObjectAttributes":
            return Optional.ofNullable(clazz.cast(updateObjectAttributes()));
        case "DeleteObject":
            return Optional.ofNullable(clazz.cast(deleteObject()));
        case "AddFacetToObject":
            return Optional.ofNullable(clazz.cast(addFacetToObject()));
        case "RemoveFacetFromObject":
            return Optional.ofNullable(clazz.cast(removeFacetFromObject()));
        case "AttachPolicy":
            return Optional.ofNullable(clazz.cast(attachPolicy()));
        case "DetachPolicy":
            return Optional.ofNullable(clazz.cast(detachPolicy()));
        case "CreateIndex":
            return Optional.ofNullable(clazz.cast(createIndex()));
        case "AttachToIndex":
            return Optional.ofNullable(clazz.cast(attachToIndex()));
        case "DetachFromIndex":
            return Optional.ofNullable(clazz.cast(detachFromIndex()));
        case "AttachTypedLink":
            return Optional.ofNullable(clazz.cast(attachTypedLink()));
        case "DetachTypedLink":
            return Optional.ofNullable(clazz.cast(detachTypedLink()));
        case "UpdateLinkAttributes":
            return Optional.ofNullable(clazz.cast(updateLinkAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteOperation, T> g) {
        return obj -> g.apply((BatchWriteOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchWriteOperation> {
        /**
         * <p>
         * Creates an object.
         * </p>
         * 
         * @param createObject
         *        Creates an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createObject(BatchCreateObject createObject);

        /**
         * <p>
         * Creates an object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchCreateObject.Builder} avoiding the need to
         * create one manually via {@link BatchCreateObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchCreateObject.Builder#build()} is called immediately and its
         * result is passed to {@link #createObject(BatchCreateObject)}.
         * 
         * @param createObject
         *        a consumer that will call methods on {@link BatchCreateObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createObject(BatchCreateObject)
         */
        default Builder createObject(Consumer<BatchCreateObject.Builder> createObject) {
            return createObject(BatchCreateObject.builder().applyMutation(createObject).build());
        }

        /**
         * <p>
         * Attaches an object to a <a>Directory</a>.
         * </p>
         * 
         * @param attachObject
         *        Attaches an object to a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachObject(BatchAttachObject attachObject);

        /**
         * <p>
         * Attaches an object to a <a>Directory</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchAttachObject.Builder} avoiding the need to
         * create one manually via {@link BatchAttachObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchAttachObject.Builder#build()} is called immediately and its
         * result is passed to {@link #attachObject(BatchAttachObject)}.
         * 
         * @param attachObject
         *        a consumer that will call methods on {@link BatchAttachObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachObject(BatchAttachObject)
         */
        default Builder attachObject(Consumer<BatchAttachObject.Builder> attachObject) {
            return attachObject(BatchAttachObject.builder().applyMutation(attachObject).build());
        }

        /**
         * <p>
         * Detaches an object from a <a>Directory</a>.
         * </p>
         * 
         * @param detachObject
         *        Detaches an object from a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachObject(BatchDetachObject detachObject);

        /**
         * <p>
         * Detaches an object from a <a>Directory</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchDetachObject.Builder} avoiding the need to
         * create one manually via {@link BatchDetachObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchDetachObject.Builder#build()} is called immediately and its
         * result is passed to {@link #detachObject(BatchDetachObject)}.
         * 
         * @param detachObject
         *        a consumer that will call methods on {@link BatchDetachObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachObject(BatchDetachObject)
         */
        default Builder detachObject(Consumer<BatchDetachObject.Builder> detachObject) {
            return detachObject(BatchDetachObject.builder().applyMutation(detachObject).build());
        }

        /**
         * <p>
         * Updates a given object's attributes.
         * </p>
         * 
         * @param updateObjectAttributes
         *        Updates a given object's attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateObjectAttributes(BatchUpdateObjectAttributes updateObjectAttributes);

        /**
         * <p>
         * Updates a given object's attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchUpdateObjectAttributes.Builder} avoiding
         * the need to create one manually via {@link BatchUpdateObjectAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchUpdateObjectAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #updateObjectAttributes(BatchUpdateObjectAttributes)}.
         * 
         * @param updateObjectAttributes
         *        a consumer that will call methods on {@link BatchUpdateObjectAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateObjectAttributes(BatchUpdateObjectAttributes)
         */
        default Builder updateObjectAttributes(Consumer<BatchUpdateObjectAttributes.Builder> updateObjectAttributes) {
            return updateObjectAttributes(BatchUpdateObjectAttributes.builder().applyMutation(updateObjectAttributes).build());
        }

        /**
         * <p>
         * Deletes an object in a <a>Directory</a>.
         * </p>
         * 
         * @param deleteObject
         *        Deletes an object in a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteObject(BatchDeleteObject deleteObject);

        /**
         * <p>
         * Deletes an object in a <a>Directory</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchDeleteObject.Builder} avoiding the need to
         * create one manually via {@link BatchDeleteObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchDeleteObject.Builder#build()} is called immediately and its
         * result is passed to {@link #deleteObject(BatchDeleteObject)}.
         * 
         * @param deleteObject
         *        a consumer that will call methods on {@link BatchDeleteObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteObject(BatchDeleteObject)
         */
        default Builder deleteObject(Consumer<BatchDeleteObject.Builder> deleteObject) {
            return deleteObject(BatchDeleteObject.builder().applyMutation(deleteObject).build());
        }

        /**
         * <p>
         * A batch operation that adds a facet to an object.
         * </p>
         * 
         * @param addFacetToObject
         *        A batch operation that adds a facet to an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addFacetToObject(BatchAddFacetToObject addFacetToObject);

        /**
         * <p>
         * A batch operation that adds a facet to an object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchAddFacetToObject.Builder} avoiding the need
         * to create one manually via {@link BatchAddFacetToObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchAddFacetToObject.Builder#build()} is called immediately and
         * its result is passed to {@link #addFacetToObject(BatchAddFacetToObject)}.
         * 
         * @param addFacetToObject
         *        a consumer that will call methods on {@link BatchAddFacetToObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addFacetToObject(BatchAddFacetToObject)
         */
        default Builder addFacetToObject(Consumer<BatchAddFacetToObject.Builder> addFacetToObject) {
            return addFacetToObject(BatchAddFacetToObject.builder().applyMutation(addFacetToObject).build());
        }

        /**
         * <p>
         * A batch operation that removes a facet from an object.
         * </p>
         * 
         * @param removeFacetFromObject
         *        A batch operation that removes a facet from an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFacetFromObject(BatchRemoveFacetFromObject removeFacetFromObject);

        /**
         * <p>
         * A batch operation that removes a facet from an object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchRemoveFacetFromObject.Builder} avoiding the
         * need to create one manually via {@link BatchRemoveFacetFromObject#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchRemoveFacetFromObject.Builder#build()} is called immediately
         * and its result is passed to {@link #removeFacetFromObject(BatchRemoveFacetFromObject)}.
         * 
         * @param removeFacetFromObject
         *        a consumer that will call methods on {@link BatchRemoveFacetFromObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeFacetFromObject(BatchRemoveFacetFromObject)
         */
        default Builder removeFacetFromObject(Consumer<BatchRemoveFacetFromObject.Builder> removeFacetFromObject) {
            return removeFacetFromObject(BatchRemoveFacetFromObject.builder().applyMutation(removeFacetFromObject).build());
        }

        /**
         * <p>
         * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
         * </p>
         * 
         * @param attachPolicy
         *        Attaches a policy object to a regular object. An object can have a limited number of attached
         *        policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachPolicy(BatchAttachPolicy attachPolicy);

        /**
         * <p>
         * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchAttachPolicy.Builder} avoiding the need to
         * create one manually via {@link BatchAttachPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchAttachPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #attachPolicy(BatchAttachPolicy)}.
         * 
         * @param attachPolicy
         *        a consumer that will call methods on {@link BatchAttachPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachPolicy(BatchAttachPolicy)
         */
        default Builder attachPolicy(Consumer<BatchAttachPolicy.Builder> attachPolicy) {
            return attachPolicy(BatchAttachPolicy.builder().applyMutation(attachPolicy).build());
        }

        /**
         * <p>
         * Detaches a policy from a <a>Directory</a>.
         * </p>
         * 
         * @param detachPolicy
         *        Detaches a policy from a <a>Directory</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachPolicy(BatchDetachPolicy detachPolicy);

        /**
         * <p>
         * Detaches a policy from a <a>Directory</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchDetachPolicy.Builder} avoiding the need to
         * create one manually via {@link BatchDetachPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchDetachPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #detachPolicy(BatchDetachPolicy)}.
         * 
         * @param detachPolicy
         *        a consumer that will call methods on {@link BatchDetachPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachPolicy(BatchDetachPolicy)
         */
        default Builder detachPolicy(Consumer<BatchDetachPolicy.Builder> detachPolicy) {
            return detachPolicy(BatchDetachPolicy.builder().applyMutation(detachPolicy).build());
        }

        /**
         * <p>
         * Creates an index object. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
         * search</a> for more information.
         * </p>
         * 
         * @param createIndex
         *        Creates an index object. See <a
         *        href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing
         *        and search</a> for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createIndex(BatchCreateIndex createIndex);

        /**
         * <p>
         * Creates an index object. See <a
         * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm">Indexing and
         * search</a> for more information.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchCreateIndex.Builder} avoiding the need to
         * create one manually via {@link BatchCreateIndex#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchCreateIndex.Builder#build()} is called immediately and its
         * result is passed to {@link #createIndex(BatchCreateIndex)}.
         * 
         * @param createIndex
         *        a consumer that will call methods on {@link BatchCreateIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createIndex(BatchCreateIndex)
         */
        default Builder createIndex(Consumer<BatchCreateIndex.Builder> createIndex) {
            return createIndex(BatchCreateIndex.builder().applyMutation(createIndex).build());
        }

        /**
         * <p>
         * Attaches the specified object to the specified index.
         * </p>
         * 
         * @param attachToIndex
         *        Attaches the specified object to the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachToIndex(BatchAttachToIndex attachToIndex);

        /**
         * <p>
         * Attaches the specified object to the specified index.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchAttachToIndex.Builder} avoiding the need to
         * create one manually via {@link BatchAttachToIndex#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchAttachToIndex.Builder#build()} is called immediately and its
         * result is passed to {@link #attachToIndex(BatchAttachToIndex)}.
         * 
         * @param attachToIndex
         *        a consumer that will call methods on {@link BatchAttachToIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachToIndex(BatchAttachToIndex)
         */
        default Builder attachToIndex(Consumer<BatchAttachToIndex.Builder> attachToIndex) {
            return attachToIndex(BatchAttachToIndex.builder().applyMutation(attachToIndex).build());
        }

        /**
         * <p>
         * Detaches the specified object from the specified index.
         * </p>
         * 
         * @param detachFromIndex
         *        Detaches the specified object from the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachFromIndex(BatchDetachFromIndex detachFromIndex);

        /**
         * <p>
         * Detaches the specified object from the specified index.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchDetachFromIndex.Builder} avoiding the need
         * to create one manually via {@link BatchDetachFromIndex#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchDetachFromIndex.Builder#build()} is called immediately and
         * its result is passed to {@link #detachFromIndex(BatchDetachFromIndex)}.
         * 
         * @param detachFromIndex
         *        a consumer that will call methods on {@link BatchDetachFromIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachFromIndex(BatchDetachFromIndex)
         */
        default Builder detachFromIndex(Consumer<BatchDetachFromIndex.Builder> detachFromIndex) {
            return detachFromIndex(BatchDetachFromIndex.builder().applyMutation(detachFromIndex).build());
        }

        /**
         * <p>
         * Attaches a typed link to a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param attachTypedLink
         *        Attaches a typed link to a specified source and target object. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTypedLink(BatchAttachTypedLink attachTypedLink);

        /**
         * <p>
         * Attaches a typed link to a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchAttachTypedLink.Builder} avoiding the need
         * to create one manually via {@link BatchAttachTypedLink#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchAttachTypedLink.Builder#build()} is called immediately and
         * its result is passed to {@link #attachTypedLink(BatchAttachTypedLink)}.
         * 
         * @param attachTypedLink
         *        a consumer that will call methods on {@link BatchAttachTypedLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachTypedLink(BatchAttachTypedLink)
         */
        default Builder attachTypedLink(Consumer<BatchAttachTypedLink.Builder> attachTypedLink) {
            return attachTypedLink(BatchAttachTypedLink.builder().applyMutation(attachTypedLink).build());
        }

        /**
         * <p>
         * Detaches a typed link from a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param detachTypedLink
         *        Detaches a typed link from a specified source and target object. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detachTypedLink(BatchDetachTypedLink detachTypedLink);

        /**
         * <p>
         * Detaches a typed link from a specified source and target object. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchDetachTypedLink.Builder} avoiding the need
         * to create one manually via {@link BatchDetachTypedLink#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchDetachTypedLink.Builder#build()} is called immediately and
         * its result is passed to {@link #detachTypedLink(BatchDetachTypedLink)}.
         * 
         * @param detachTypedLink
         *        a consumer that will call methods on {@link BatchDetachTypedLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detachTypedLink(BatchDetachTypedLink)
         */
        default Builder detachTypedLink(Consumer<BatchDetachTypedLink.Builder> detachTypedLink) {
            return detachTypedLink(BatchDetachTypedLink.builder().applyMutation(detachTypedLink).build());
        }

        /**
         * <p>
         * Updates a given object's attributes.
         * </p>
         * 
         * @param updateLinkAttributes
         *        Updates a given object's attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateLinkAttributes(BatchUpdateLinkAttributes updateLinkAttributes);

        /**
         * <p>
         * Updates a given object's attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchUpdateLinkAttributes.Builder} avoiding the
         * need to create one manually via {@link BatchUpdateLinkAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchUpdateLinkAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #updateLinkAttributes(BatchUpdateLinkAttributes)}.
         * 
         * @param updateLinkAttributes
         *        a consumer that will call methods on {@link BatchUpdateLinkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateLinkAttributes(BatchUpdateLinkAttributes)
         */
        default Builder updateLinkAttributes(Consumer<BatchUpdateLinkAttributes.Builder> updateLinkAttributes) {
            return updateLinkAttributes(BatchUpdateLinkAttributes.builder().applyMutation(updateLinkAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BatchCreateObject createObject;

        private BatchAttachObject attachObject;

        private BatchDetachObject detachObject;

        private BatchUpdateObjectAttributes updateObjectAttributes;

        private BatchDeleteObject deleteObject;

        private BatchAddFacetToObject addFacetToObject;

        private BatchRemoveFacetFromObject removeFacetFromObject;

        private BatchAttachPolicy attachPolicy;

        private BatchDetachPolicy detachPolicy;

        private BatchCreateIndex createIndex;

        private BatchAttachToIndex attachToIndex;

        private BatchDetachFromIndex detachFromIndex;

        private BatchAttachTypedLink attachTypedLink;

        private BatchDetachTypedLink detachTypedLink;

        private BatchUpdateLinkAttributes updateLinkAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperation model) {
            createObject(model.createObject);
            attachObject(model.attachObject);
            detachObject(model.detachObject);
            updateObjectAttributes(model.updateObjectAttributes);
            deleteObject(model.deleteObject);
            addFacetToObject(model.addFacetToObject);
            removeFacetFromObject(model.removeFacetFromObject);
            attachPolicy(model.attachPolicy);
            detachPolicy(model.detachPolicy);
            createIndex(model.createIndex);
            attachToIndex(model.attachToIndex);
            detachFromIndex(model.detachFromIndex);
            attachTypedLink(model.attachTypedLink);
            detachTypedLink(model.detachTypedLink);
            updateLinkAttributes(model.updateLinkAttributes);
        }

        public final BatchCreateObject.Builder getCreateObject() {
            return createObject != null ? createObject.toBuilder() : null;
        }

        public final void setCreateObject(BatchCreateObject.BuilderImpl createObject) {
            this.createObject = createObject != null ? createObject.build() : null;
        }

        @Override
        @Transient
        public final Builder createObject(BatchCreateObject createObject) {
            this.createObject = createObject;
            return this;
        }

        public final BatchAttachObject.Builder getAttachObject() {
            return attachObject != null ? attachObject.toBuilder() : null;
        }

        public final void setAttachObject(BatchAttachObject.BuilderImpl attachObject) {
            this.attachObject = attachObject != null ? attachObject.build() : null;
        }

        @Override
        @Transient
        public final Builder attachObject(BatchAttachObject attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final BatchDetachObject.Builder getDetachObject() {
            return detachObject != null ? detachObject.toBuilder() : null;
        }

        public final void setDetachObject(BatchDetachObject.BuilderImpl detachObject) {
            this.detachObject = detachObject != null ? detachObject.build() : null;
        }

        @Override
        @Transient
        public final Builder detachObject(BatchDetachObject detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final BatchUpdateObjectAttributes.Builder getUpdateObjectAttributes() {
            return updateObjectAttributes != null ? updateObjectAttributes.toBuilder() : null;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributes.BuilderImpl updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes != null ? updateObjectAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributes updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final BatchDeleteObject.Builder getDeleteObject() {
            return deleteObject != null ? deleteObject.toBuilder() : null;
        }

        public final void setDeleteObject(BatchDeleteObject.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        @Override
        @Transient
        public final Builder deleteObject(BatchDeleteObject deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final BatchAddFacetToObject.Builder getAddFacetToObject() {
            return addFacetToObject != null ? addFacetToObject.toBuilder() : null;
        }

        public final void setAddFacetToObject(BatchAddFacetToObject.BuilderImpl addFacetToObject) {
            this.addFacetToObject = addFacetToObject != null ? addFacetToObject.build() : null;
        }

        @Override
        @Transient
        public final Builder addFacetToObject(BatchAddFacetToObject addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final BatchRemoveFacetFromObject.Builder getRemoveFacetFromObject() {
            return removeFacetFromObject != null ? removeFacetFromObject.toBuilder() : null;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObject.BuilderImpl removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject != null ? removeFacetFromObject.build() : null;
        }

        @Override
        @Transient
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObject removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final BatchAttachPolicy.Builder getAttachPolicy() {
            return attachPolicy != null ? attachPolicy.toBuilder() : null;
        }

        public final void setAttachPolicy(BatchAttachPolicy.BuilderImpl attachPolicy) {
            this.attachPolicy = attachPolicy != null ? attachPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder attachPolicy(BatchAttachPolicy attachPolicy) {
            this.attachPolicy = attachPolicy;
            return this;
        }

        public final BatchDetachPolicy.Builder getDetachPolicy() {
            return detachPolicy != null ? detachPolicy.toBuilder() : null;
        }

        public final void setDetachPolicy(BatchDetachPolicy.BuilderImpl detachPolicy) {
            this.detachPolicy = detachPolicy != null ? detachPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder detachPolicy(BatchDetachPolicy detachPolicy) {
            this.detachPolicy = detachPolicy;
            return this;
        }

        public final BatchCreateIndex.Builder getCreateIndex() {
            return createIndex != null ? createIndex.toBuilder() : null;
        }

        public final void setCreateIndex(BatchCreateIndex.BuilderImpl createIndex) {
            this.createIndex = createIndex != null ? createIndex.build() : null;
        }

        @Override
        @Transient
        public final Builder createIndex(BatchCreateIndex createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        public final BatchAttachToIndex.Builder getAttachToIndex() {
            return attachToIndex != null ? attachToIndex.toBuilder() : null;
        }

        public final void setAttachToIndex(BatchAttachToIndex.BuilderImpl attachToIndex) {
            this.attachToIndex = attachToIndex != null ? attachToIndex.build() : null;
        }

        @Override
        @Transient
        public final Builder attachToIndex(BatchAttachToIndex attachToIndex) {
            this.attachToIndex = attachToIndex;
            return this;
        }

        public final BatchDetachFromIndex.Builder getDetachFromIndex() {
            return detachFromIndex != null ? detachFromIndex.toBuilder() : null;
        }

        public final void setDetachFromIndex(BatchDetachFromIndex.BuilderImpl detachFromIndex) {
            this.detachFromIndex = detachFromIndex != null ? detachFromIndex.build() : null;
        }

        @Override
        @Transient
        public final Builder detachFromIndex(BatchDetachFromIndex detachFromIndex) {
            this.detachFromIndex = detachFromIndex;
            return this;
        }

        public final BatchAttachTypedLink.Builder getAttachTypedLink() {
            return attachTypedLink != null ? attachTypedLink.toBuilder() : null;
        }

        public final void setAttachTypedLink(BatchAttachTypedLink.BuilderImpl attachTypedLink) {
            this.attachTypedLink = attachTypedLink != null ? attachTypedLink.build() : null;
        }

        @Override
        @Transient
        public final Builder attachTypedLink(BatchAttachTypedLink attachTypedLink) {
            this.attachTypedLink = attachTypedLink;
            return this;
        }

        public final BatchDetachTypedLink.Builder getDetachTypedLink() {
            return detachTypedLink != null ? detachTypedLink.toBuilder() : null;
        }

        public final void setDetachTypedLink(BatchDetachTypedLink.BuilderImpl detachTypedLink) {
            this.detachTypedLink = detachTypedLink != null ? detachTypedLink.build() : null;
        }

        @Override
        @Transient
        public final Builder detachTypedLink(BatchDetachTypedLink detachTypedLink) {
            this.detachTypedLink = detachTypedLink;
            return this;
        }

        public final BatchUpdateLinkAttributes.Builder getUpdateLinkAttributes() {
            return updateLinkAttributes != null ? updateLinkAttributes.toBuilder() : null;
        }

        public final void setUpdateLinkAttributes(BatchUpdateLinkAttributes.BuilderImpl updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes != null ? updateLinkAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder updateLinkAttributes(BatchUpdateLinkAttributes updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes;
            return this;
        }

        @Override
        public BatchWriteOperation build() {
            return new BatchWriteOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
