/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchRead</code> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchReadOperationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchReadOperationResponse.Builder, BatchReadOperationResponse> {
    private static final SdkField<BatchReadSuccessfulResponse> SUCCESSFUL_RESPONSE_FIELD = SdkField
            .<BatchReadSuccessfulResponse> builder(MarshallingType.SDK_POJO).memberName("SuccessfulResponse")
            .getter(getter(BatchReadOperationResponse::successfulResponse)).setter(setter(Builder::successfulResponse))
            .constructor(BatchReadSuccessfulResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulResponse").build())
            .build();

    private static final SdkField<BatchReadException> EXCEPTION_RESPONSE_FIELD = SdkField
            .<BatchReadException> builder(MarshallingType.SDK_POJO).memberName("ExceptionResponse")
            .getter(getter(BatchReadOperationResponse::exceptionResponse)).setter(setter(Builder::exceptionResponse))
            .constructor(BatchReadException::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExceptionResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_RESPONSE_FIELD,
            EXCEPTION_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchReadSuccessfulResponse successfulResponse;

    private final BatchReadException exceptionResponse;

    private BatchReadOperationResponse(BuilderImpl builder) {
        this.successfulResponse = builder.successfulResponse;
        this.exceptionResponse = builder.exceptionResponse;
    }

    /**
     * <p>
     * Identifies which operation in a batch has succeeded.
     * </p>
     * 
     * @return Identifies which operation in a batch has succeeded.
     */
    public final BatchReadSuccessfulResponse successfulResponse() {
        return successfulResponse;
    }

    /**
     * <p>
     * Identifies which operation in a batch has failed.
     * </p>
     * 
     * @return Identifies which operation in a batch has failed.
     */
    public final BatchReadException exceptionResponse() {
        return exceptionResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successfulResponse());
        hashCode = 31 * hashCode + Objects.hashCode(exceptionResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadOperationResponse)) {
            return false;
        }
        BatchReadOperationResponse other = (BatchReadOperationResponse) obj;
        return Objects.equals(successfulResponse(), other.successfulResponse())
                && Objects.equals(exceptionResponse(), other.exceptionResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchReadOperationResponse").add("SuccessfulResponse", successfulResponse())
                .add("ExceptionResponse", exceptionResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulResponse":
            return Optional.ofNullable(clazz.cast(successfulResponse()));
        case "ExceptionResponse":
            return Optional.ofNullable(clazz.cast(exceptionResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchReadOperationResponse, T> g) {
        return obj -> g.apply((BatchReadOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchReadOperationResponse> {
        /**
         * <p>
         * Identifies which operation in a batch has succeeded.
         * </p>
         * 
         * @param successfulResponse
         *        Identifies which operation in a batch has succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulResponse(BatchReadSuccessfulResponse successfulResponse);

        /**
         * <p>
         * Identifies which operation in a batch has succeeded.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchReadSuccessfulResponse.Builder} avoiding
         * the need to create one manually via {@link BatchReadSuccessfulResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchReadSuccessfulResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #successfulResponse(BatchReadSuccessfulResponse)}.
         * 
         * @param successfulResponse
         *        a consumer that will call methods on {@link BatchReadSuccessfulResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulResponse(BatchReadSuccessfulResponse)
         */
        default Builder successfulResponse(Consumer<BatchReadSuccessfulResponse.Builder> successfulResponse) {
            return successfulResponse(BatchReadSuccessfulResponse.builder().applyMutation(successfulResponse).build());
        }

        /**
         * <p>
         * Identifies which operation in a batch has failed.
         * </p>
         * 
         * @param exceptionResponse
         *        Identifies which operation in a batch has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionResponse(BatchReadException exceptionResponse);

        /**
         * <p>
         * Identifies which operation in a batch has failed.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchReadException.Builder} avoiding the need to
         * create one manually via {@link BatchReadException#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchReadException.Builder#build()} is called immediately and its
         * result is passed to {@link #exceptionResponse(BatchReadException)}.
         * 
         * @param exceptionResponse
         *        a consumer that will call methods on {@link BatchReadException.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exceptionResponse(BatchReadException)
         */
        default Builder exceptionResponse(Consumer<BatchReadException.Builder> exceptionResponse) {
            return exceptionResponse(BatchReadException.builder().applyMutation(exceptionResponse).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BatchReadSuccessfulResponse successfulResponse;

        private BatchReadException exceptionResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadOperationResponse model) {
            successfulResponse(model.successfulResponse);
            exceptionResponse(model.exceptionResponse);
        }

        public final BatchReadSuccessfulResponse.Builder getSuccessfulResponse() {
            return successfulResponse != null ? successfulResponse.toBuilder() : null;
        }

        public final void setSuccessfulResponse(BatchReadSuccessfulResponse.BuilderImpl successfulResponse) {
            this.successfulResponse = successfulResponse != null ? successfulResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder successfulResponse(BatchReadSuccessfulResponse successfulResponse) {
            this.successfulResponse = successfulResponse;
            return this;
        }

        public final BatchReadException.Builder getExceptionResponse() {
            return exceptionResponse != null ? exceptionResponse.toBuilder() : null;
        }

        public final void setExceptionResponse(BatchReadException.BuilderImpl exceptionResponse) {
            this.exceptionResponse = exceptionResponse != null ? exceptionResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder exceptionResponse(BatchReadException exceptionResponse) {
            this.exceptionResponse = exceptionResponse;
            return this;
        }

        @Override
        public BatchReadOperationResponse build() {
            return new BatchReadOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
