/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchRead</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchReadOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchReadOperation.Builder, BatchReadOperation> {
    private static final SdkField<BatchListObjectAttributes> LIST_OBJECT_ATTRIBUTES_FIELD = SdkField
            .<BatchListObjectAttributes> builder(MarshallingType.SDK_POJO).memberName("ListObjectAttributes")
            .getter(getter(BatchReadOperation::listObjectAttributes)).setter(setter(Builder::listObjectAttributes))
            .constructor(BatchListObjectAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectAttributes").build())
            .build();

    private static final SdkField<BatchListObjectChildren> LIST_OBJECT_CHILDREN_FIELD = SdkField
            .<BatchListObjectChildren> builder(MarshallingType.SDK_POJO).memberName("ListObjectChildren")
            .getter(getter(BatchReadOperation::listObjectChildren)).setter(setter(Builder::listObjectChildren))
            .constructor(BatchListObjectChildren::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectChildren").build())
            .build();

    private static final SdkField<BatchListAttachedIndices> LIST_ATTACHED_INDICES_FIELD = SdkField
            .<BatchListAttachedIndices> builder(MarshallingType.SDK_POJO).memberName("ListAttachedIndices")
            .getter(getter(BatchReadOperation::listAttachedIndices)).setter(setter(Builder::listAttachedIndices))
            .constructor(BatchListAttachedIndices::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListAttachedIndices").build())
            .build();

    private static final SdkField<BatchListObjectParentPaths> LIST_OBJECT_PARENT_PATHS_FIELD = SdkField
            .<BatchListObjectParentPaths> builder(MarshallingType.SDK_POJO).memberName("ListObjectParentPaths")
            .getter(getter(BatchReadOperation::listObjectParentPaths)).setter(setter(Builder::listObjectParentPaths))
            .constructor(BatchListObjectParentPaths::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectParentPaths").build())
            .build();

    private static final SdkField<BatchGetObjectInformation> GET_OBJECT_INFORMATION_FIELD = SdkField
            .<BatchGetObjectInformation> builder(MarshallingType.SDK_POJO).memberName("GetObjectInformation")
            .getter(getter(BatchReadOperation::getObjectInformation)).setter(setter(Builder::getObjectInformation))
            .constructor(BatchGetObjectInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetObjectInformation").build())
            .build();

    private static final SdkField<BatchGetObjectAttributes> GET_OBJECT_ATTRIBUTES_FIELD = SdkField
            .<BatchGetObjectAttributes> builder(MarshallingType.SDK_POJO).memberName("GetObjectAttributes")
            .getter(getter(BatchReadOperation::getObjectAttributes)).setter(setter(Builder::getObjectAttributes))
            .constructor(BatchGetObjectAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetObjectAttributes").build())
            .build();

    private static final SdkField<BatchListObjectParents> LIST_OBJECT_PARENTS_FIELD = SdkField
            .<BatchListObjectParents> builder(MarshallingType.SDK_POJO).memberName("ListObjectParents")
            .getter(getter(BatchReadOperation::listObjectParents)).setter(setter(Builder::listObjectParents))
            .constructor(BatchListObjectParents::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectParents").build()).build();

    private static final SdkField<BatchListObjectPolicies> LIST_OBJECT_POLICIES_FIELD = SdkField
            .<BatchListObjectPolicies> builder(MarshallingType.SDK_POJO).memberName("ListObjectPolicies")
            .getter(getter(BatchReadOperation::listObjectPolicies)).setter(setter(Builder::listObjectPolicies))
            .constructor(BatchListObjectPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectPolicies").build())
            .build();

    private static final SdkField<BatchListPolicyAttachments> LIST_POLICY_ATTACHMENTS_FIELD = SdkField
            .<BatchListPolicyAttachments> builder(MarshallingType.SDK_POJO).memberName("ListPolicyAttachments")
            .getter(getter(BatchReadOperation::listPolicyAttachments)).setter(setter(Builder::listPolicyAttachments))
            .constructor(BatchListPolicyAttachments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListPolicyAttachments").build())
            .build();

    private static final SdkField<BatchLookupPolicy> LOOKUP_POLICY_FIELD = SdkField
            .<BatchLookupPolicy> builder(MarshallingType.SDK_POJO).memberName("LookupPolicy")
            .getter(getter(BatchReadOperation::lookupPolicy)).setter(setter(Builder::lookupPolicy))
            .constructor(BatchLookupPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookupPolicy").build()).build();

    private static final SdkField<BatchListIndex> LIST_INDEX_FIELD = SdkField.<BatchListIndex> builder(MarshallingType.SDK_POJO)
            .memberName("ListIndex").getter(getter(BatchReadOperation::listIndex)).setter(setter(Builder::listIndex))
            .constructor(BatchListIndex::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListIndex").build()).build();

    private static final SdkField<BatchListOutgoingTypedLinks> LIST_OUTGOING_TYPED_LINKS_FIELD = SdkField
            .<BatchListOutgoingTypedLinks> builder(MarshallingType.SDK_POJO).memberName("ListOutgoingTypedLinks")
            .getter(getter(BatchReadOperation::listOutgoingTypedLinks)).setter(setter(Builder::listOutgoingTypedLinks))
            .constructor(BatchListOutgoingTypedLinks::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOutgoingTypedLinks").build())
            .build();

    private static final SdkField<BatchListIncomingTypedLinks> LIST_INCOMING_TYPED_LINKS_FIELD = SdkField
            .<BatchListIncomingTypedLinks> builder(MarshallingType.SDK_POJO).memberName("ListIncomingTypedLinks")
            .getter(getter(BatchReadOperation::listIncomingTypedLinks)).setter(setter(Builder::listIncomingTypedLinks))
            .constructor(BatchListIncomingTypedLinks::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListIncomingTypedLinks").build())
            .build();

    private static final SdkField<BatchGetLinkAttributes> GET_LINK_ATTRIBUTES_FIELD = SdkField
            .<BatchGetLinkAttributes> builder(MarshallingType.SDK_POJO).memberName("GetLinkAttributes")
            .getter(getter(BatchReadOperation::getLinkAttributes)).setter(setter(Builder::getLinkAttributes))
            .constructor(BatchGetLinkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetLinkAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_OBJECT_ATTRIBUTES_FIELD,
            LIST_OBJECT_CHILDREN_FIELD, LIST_ATTACHED_INDICES_FIELD, LIST_OBJECT_PARENT_PATHS_FIELD,
            GET_OBJECT_INFORMATION_FIELD, GET_OBJECT_ATTRIBUTES_FIELD, LIST_OBJECT_PARENTS_FIELD, LIST_OBJECT_POLICIES_FIELD,
            LIST_POLICY_ATTACHMENTS_FIELD, LOOKUP_POLICY_FIELD, LIST_INDEX_FIELD, LIST_OUTGOING_TYPED_LINKS_FIELD,
            LIST_INCOMING_TYPED_LINKS_FIELD, GET_LINK_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchListObjectAttributes listObjectAttributes;

    private final BatchListObjectChildren listObjectChildren;

    private final BatchListAttachedIndices listAttachedIndices;

    private final BatchListObjectParentPaths listObjectParentPaths;

    private final BatchGetObjectInformation getObjectInformation;

    private final BatchGetObjectAttributes getObjectAttributes;

    private final BatchListObjectParents listObjectParents;

    private final BatchListObjectPolicies listObjectPolicies;

    private final BatchListPolicyAttachments listPolicyAttachments;

    private final BatchLookupPolicy lookupPolicy;

    private final BatchListIndex listIndex;

    private final BatchListOutgoingTypedLinks listOutgoingTypedLinks;

    private final BatchListIncomingTypedLinks listIncomingTypedLinks;

    private final BatchGetLinkAttributes getLinkAttributes;

    private BatchReadOperation(BuilderImpl builder) {
        this.listObjectAttributes = builder.listObjectAttributes;
        this.listObjectChildren = builder.listObjectChildren;
        this.listAttachedIndices = builder.listAttachedIndices;
        this.listObjectParentPaths = builder.listObjectParentPaths;
        this.getObjectInformation = builder.getObjectInformation;
        this.getObjectAttributes = builder.getObjectAttributes;
        this.listObjectParents = builder.listObjectParents;
        this.listObjectPolicies = builder.listObjectPolicies;
        this.listPolicyAttachments = builder.listPolicyAttachments;
        this.lookupPolicy = builder.lookupPolicy;
        this.listIndex = builder.listIndex;
        this.listOutgoingTypedLinks = builder.listOutgoingTypedLinks;
        this.listIncomingTypedLinks = builder.listIncomingTypedLinks;
        this.getLinkAttributes = builder.getLinkAttributes;
    }

    /**
     * <p>
     * Lists all attributes that are associated with an object.
     * </p>
     * 
     * @return Lists all attributes that are associated with an object.
     */
    public final BatchListObjectAttributes listObjectAttributes() {
        return listObjectAttributes;
    }

    /**
     * <p>
     * Returns a paginated list of child objects that are associated with a given object.
     * </p>
     * 
     * @return Returns a paginated list of child objects that are associated with a given object.
     */
    public final BatchListObjectChildren listObjectChildren() {
        return listObjectChildren;
    }

    /**
     * <p>
     * Lists indices attached to an object.
     * </p>
     * 
     * @return Lists indices attached to an object.
     */
    public final BatchListAttachedIndices listAttachedIndices() {
        return listAttachedIndices;
    }

    /**
     * <p>
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
     * objects. For more information about objects, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     * >Directory Structure</a>.
     * </p>
     * 
     * @return Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index
     *         node objects. For more information about objects, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     *         >Directory Structure</a>.
     */
    public final BatchListObjectParentPaths listObjectParentPaths() {
        return listObjectParentPaths;
    }

    /**
     * <p>
     * Retrieves metadata about an object.
     * </p>
     * 
     * @return Retrieves metadata about an object.
     */
    public final BatchGetObjectInformation getObjectInformation() {
        return getObjectInformation;
    }

    /**
     * <p>
     * Retrieves attributes within a facet that are associated with an object.
     * </p>
     * 
     * @return Retrieves attributes within a facet that are associated with an object.
     */
    public final BatchGetObjectAttributes getObjectAttributes() {
        return getObjectAttributes;
    }

    /**
     * <p>
     * Lists parent objects that are associated with a given object in pagination fashion.
     * </p>
     * 
     * @return Lists parent objects that are associated with a given object in pagination fashion.
     */
    public final BatchListObjectParents listObjectParents() {
        return listObjectParents;
    }

    /**
     * <p>
     * Returns policies attached to an object in pagination fashion.
     * </p>
     * 
     * @return Returns policies attached to an object in pagination fashion.
     */
    public final BatchListObjectPolicies listObjectPolicies() {
        return listObjectPolicies;
    }

    /**
     * <p>
     * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     * </p>
     * 
     * @return Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     */
    public final BatchListPolicyAttachments listPolicyAttachments() {
        return listPolicyAttachments;
    }

    /**
     * <p>
     * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
     * present, an empty list is returned. If policies are present, and if some objects don't have the policies
     * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
     * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the
     * root from the target object are ignored. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * 
     * @return Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no
     *         policies present, an empty list is returned. If policies are present, and if some objects don't have the
     *         policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are
     *         present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>.
     *         Paths that don't lead to the root from the target object are ignored. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     *         >Policies</a>.
     */
    public final BatchLookupPolicy lookupPolicy() {
        return lookupPolicy;
    }

    /**
     * <p>
     * Lists objects attached to the specified index.
     * </p>
     * 
     * @return Lists objects attached to the specified index.
     */
    public final BatchListIndex listIndex() {
        return listIndex;
    }

    /**
     * <p>
     * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
     *         supports filtering by typed link facet and identity attributes. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchListOutgoingTypedLinks listOutgoingTypedLinks() {
        return listOutgoingTypedLinks;
    }

    /**
     * <p>
     * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
     *         supports filtering by typed link facet and identity attributes. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchListIncomingTypedLinks listIncomingTypedLinks() {
        return listIncomingTypedLinks;
    }

    /**
     * <p>
     * Retrieves attributes that are associated with a typed link.
     * </p>
     * 
     * @return Retrieves attributes that are associated with a typed link.
     */
    public final BatchGetLinkAttributes getLinkAttributes() {
        return getLinkAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectChildren());
        hashCode = 31 * hashCode + Objects.hashCode(listAttachedIndices());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectParentPaths());
        hashCode = 31 * hashCode + Objects.hashCode(getObjectInformation());
        hashCode = 31 * hashCode + Objects.hashCode(getObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectParents());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(listPolicyAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(lookupPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(listIndex());
        hashCode = 31 * hashCode + Objects.hashCode(listOutgoingTypedLinks());
        hashCode = 31 * hashCode + Objects.hashCode(listIncomingTypedLinks());
        hashCode = 31 * hashCode + Objects.hashCode(getLinkAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadOperation)) {
            return false;
        }
        BatchReadOperation other = (BatchReadOperation) obj;
        return Objects.equals(listObjectAttributes(), other.listObjectAttributes())
                && Objects.equals(listObjectChildren(), other.listObjectChildren())
                && Objects.equals(listAttachedIndices(), other.listAttachedIndices())
                && Objects.equals(listObjectParentPaths(), other.listObjectParentPaths())
                && Objects.equals(getObjectInformation(), other.getObjectInformation())
                && Objects.equals(getObjectAttributes(), other.getObjectAttributes())
                && Objects.equals(listObjectParents(), other.listObjectParents())
                && Objects.equals(listObjectPolicies(), other.listObjectPolicies())
                && Objects.equals(listPolicyAttachments(), other.listPolicyAttachments())
                && Objects.equals(lookupPolicy(), other.lookupPolicy()) && Objects.equals(listIndex(), other.listIndex())
                && Objects.equals(listOutgoingTypedLinks(), other.listOutgoingTypedLinks())
                && Objects.equals(listIncomingTypedLinks(), other.listIncomingTypedLinks())
                && Objects.equals(getLinkAttributes(), other.getLinkAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchReadOperation").add("ListObjectAttributes", listObjectAttributes())
                .add("ListObjectChildren", listObjectChildren()).add("ListAttachedIndices", listAttachedIndices())
                .add("ListObjectParentPaths", listObjectParentPaths()).add("GetObjectInformation", getObjectInformation())
                .add("GetObjectAttributes", getObjectAttributes()).add("ListObjectParents", listObjectParents())
                .add("ListObjectPolicies", listObjectPolicies()).add("ListPolicyAttachments", listPolicyAttachments())
                .add("LookupPolicy", lookupPolicy()).add("ListIndex", listIndex())
                .add("ListOutgoingTypedLinks", listOutgoingTypedLinks()).add("ListIncomingTypedLinks", listIncomingTypedLinks())
                .add("GetLinkAttributes", getLinkAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListObjectAttributes":
            return Optional.ofNullable(clazz.cast(listObjectAttributes()));
        case "ListObjectChildren":
            return Optional.ofNullable(clazz.cast(listObjectChildren()));
        case "ListAttachedIndices":
            return Optional.ofNullable(clazz.cast(listAttachedIndices()));
        case "ListObjectParentPaths":
            return Optional.ofNullable(clazz.cast(listObjectParentPaths()));
        case "GetObjectInformation":
            return Optional.ofNullable(clazz.cast(getObjectInformation()));
        case "GetObjectAttributes":
            return Optional.ofNullable(clazz.cast(getObjectAttributes()));
        case "ListObjectParents":
            return Optional.ofNullable(clazz.cast(listObjectParents()));
        case "ListObjectPolicies":
            return Optional.ofNullable(clazz.cast(listObjectPolicies()));
        case "ListPolicyAttachments":
            return Optional.ofNullable(clazz.cast(listPolicyAttachments()));
        case "LookupPolicy":
            return Optional.ofNullable(clazz.cast(lookupPolicy()));
        case "ListIndex":
            return Optional.ofNullable(clazz.cast(listIndex()));
        case "ListOutgoingTypedLinks":
            return Optional.ofNullable(clazz.cast(listOutgoingTypedLinks()));
        case "ListIncomingTypedLinks":
            return Optional.ofNullable(clazz.cast(listIncomingTypedLinks()));
        case "GetLinkAttributes":
            return Optional.ofNullable(clazz.cast(getLinkAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchReadOperation, T> g) {
        return obj -> g.apply((BatchReadOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchReadOperation> {
        /**
         * <p>
         * Lists all attributes that are associated with an object.
         * </p>
         * 
         * @param listObjectAttributes
         *        Lists all attributes that are associated with an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectAttributes(BatchListObjectAttributes listObjectAttributes);

        /**
         * <p>
         * Lists all attributes that are associated with an object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListObjectAttributes.Builder} avoiding the
         * need to create one manually via {@link BatchListObjectAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #listObjectAttributes(BatchListObjectAttributes)}.
         * 
         * @param listObjectAttributes
         *        a consumer that will call methods on {@link BatchListObjectAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectAttributes(BatchListObjectAttributes)
         */
        default Builder listObjectAttributes(Consumer<BatchListObjectAttributes.Builder> listObjectAttributes) {
            return listObjectAttributes(BatchListObjectAttributes.builder().applyMutation(listObjectAttributes).build());
        }

        /**
         * <p>
         * Returns a paginated list of child objects that are associated with a given object.
         * </p>
         * 
         * @param listObjectChildren
         *        Returns a paginated list of child objects that are associated with a given object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectChildren(BatchListObjectChildren listObjectChildren);

        /**
         * <p>
         * Returns a paginated list of child objects that are associated with a given object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListObjectChildren.Builder} avoiding the
         * need to create one manually via {@link BatchListObjectChildren#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectChildren.Builder#build()} is called immediately
         * and its result is passed to {@link #listObjectChildren(BatchListObjectChildren)}.
         * 
         * @param listObjectChildren
         *        a consumer that will call methods on {@link BatchListObjectChildren.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectChildren(BatchListObjectChildren)
         */
        default Builder listObjectChildren(Consumer<BatchListObjectChildren.Builder> listObjectChildren) {
            return listObjectChildren(BatchListObjectChildren.builder().applyMutation(listObjectChildren).build());
        }

        /**
         * <p>
         * Lists indices attached to an object.
         * </p>
         * 
         * @param listAttachedIndices
         *        Lists indices attached to an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAttachedIndices(BatchListAttachedIndices listAttachedIndices);

        /**
         * <p>
         * Lists indices attached to an object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListAttachedIndices.Builder} avoiding the
         * need to create one manually via {@link BatchListAttachedIndices#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListAttachedIndices.Builder#build()} is called immediately
         * and its result is passed to {@link #listAttachedIndices(BatchListAttachedIndices)}.
         * 
         * @param listAttachedIndices
         *        a consumer that will call methods on {@link BatchListAttachedIndices.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listAttachedIndices(BatchListAttachedIndices)
         */
        default Builder listAttachedIndices(Consumer<BatchListAttachedIndices.Builder> listAttachedIndices) {
            return listAttachedIndices(BatchListAttachedIndices.builder().applyMutation(listAttachedIndices).build());
        }

        /**
         * <p>
         * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
         * objects. For more information about objects, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
         * >Directory Structure</a>.
         * </p>
         * 
         * @param listObjectParentPaths
         *        Retrieves all available parent paths for any object type such as node, leaf node, policy node, and
         *        index node objects. For more information about objects, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
         *        >Directory Structure</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectParentPaths(BatchListObjectParentPaths listObjectParentPaths);

        /**
         * <p>
         * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
         * objects. For more information about objects, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
         * >Directory Structure</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListObjectParentPaths.Builder} avoiding the
         * need to create one manually via {@link BatchListObjectParentPaths#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectParentPaths.Builder#build()} is called immediately
         * and its result is passed to {@link #listObjectParentPaths(BatchListObjectParentPaths)}.
         * 
         * @param listObjectParentPaths
         *        a consumer that will call methods on {@link BatchListObjectParentPaths.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectParentPaths(BatchListObjectParentPaths)
         */
        default Builder listObjectParentPaths(Consumer<BatchListObjectParentPaths.Builder> listObjectParentPaths) {
            return listObjectParentPaths(BatchListObjectParentPaths.builder().applyMutation(listObjectParentPaths).build());
        }

        /**
         * <p>
         * Retrieves metadata about an object.
         * </p>
         * 
         * @param getObjectInformation
         *        Retrieves metadata about an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder getObjectInformation(BatchGetObjectInformation getObjectInformation);

        /**
         * <p>
         * Retrieves metadata about an object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchGetObjectInformation.Builder} avoiding the
         * need to create one manually via {@link BatchGetObjectInformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchGetObjectInformation.Builder#build()} is called immediately
         * and its result is passed to {@link #getObjectInformation(BatchGetObjectInformation)}.
         * 
         * @param getObjectInformation
         *        a consumer that will call methods on {@link BatchGetObjectInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #getObjectInformation(BatchGetObjectInformation)
         */
        default Builder getObjectInformation(Consumer<BatchGetObjectInformation.Builder> getObjectInformation) {
            return getObjectInformation(BatchGetObjectInformation.builder().applyMutation(getObjectInformation).build());
        }

        /**
         * <p>
         * Retrieves attributes within a facet that are associated with an object.
         * </p>
         * 
         * @param getObjectAttributes
         *        Retrieves attributes within a facet that are associated with an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder getObjectAttributes(BatchGetObjectAttributes getObjectAttributes);

        /**
         * <p>
         * Retrieves attributes within a facet that are associated with an object.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchGetObjectAttributes.Builder} avoiding the
         * need to create one manually via {@link BatchGetObjectAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchGetObjectAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #getObjectAttributes(BatchGetObjectAttributes)}.
         * 
         * @param getObjectAttributes
         *        a consumer that will call methods on {@link BatchGetObjectAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #getObjectAttributes(BatchGetObjectAttributes)
         */
        default Builder getObjectAttributes(Consumer<BatchGetObjectAttributes.Builder> getObjectAttributes) {
            return getObjectAttributes(BatchGetObjectAttributes.builder().applyMutation(getObjectAttributes).build());
        }

        /**
         * <p>
         * Lists parent objects that are associated with a given object in pagination fashion.
         * </p>
         * 
         * @param listObjectParents
         *        Lists parent objects that are associated with a given object in pagination fashion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectParents(BatchListObjectParents listObjectParents);

        /**
         * <p>
         * Lists parent objects that are associated with a given object in pagination fashion.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListObjectParents.Builder} avoiding the
         * need to create one manually via {@link BatchListObjectParents#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectParents.Builder#build()} is called immediately and
         * its result is passed to {@link #listObjectParents(BatchListObjectParents)}.
         * 
         * @param listObjectParents
         *        a consumer that will call methods on {@link BatchListObjectParents.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectParents(BatchListObjectParents)
         */
        default Builder listObjectParents(Consumer<BatchListObjectParents.Builder> listObjectParents) {
            return listObjectParents(BatchListObjectParents.builder().applyMutation(listObjectParents).build());
        }

        /**
         * <p>
         * Returns policies attached to an object in pagination fashion.
         * </p>
         * 
         * @param listObjectPolicies
         *        Returns policies attached to an object in pagination fashion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectPolicies(BatchListObjectPolicies listObjectPolicies);

        /**
         * <p>
         * Returns policies attached to an object in pagination fashion.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListObjectPolicies.Builder} avoiding the
         * need to create one manually via {@link BatchListObjectPolicies#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectPolicies.Builder#build()} is called immediately
         * and its result is passed to {@link #listObjectPolicies(BatchListObjectPolicies)}.
         * 
         * @param listObjectPolicies
         *        a consumer that will call methods on {@link BatchListObjectPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectPolicies(BatchListObjectPolicies)
         */
        default Builder listObjectPolicies(Consumer<BatchListObjectPolicies.Builder> listObjectPolicies) {
            return listObjectPolicies(BatchListObjectPolicies.builder().applyMutation(listObjectPolicies).build());
        }

        /**
         * <p>
         * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
         * </p>
         * 
         * @param listPolicyAttachments
         *        Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listPolicyAttachments(BatchListPolicyAttachments listPolicyAttachments);

        /**
         * <p>
         * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListPolicyAttachments.Builder} avoiding the
         * need to create one manually via {@link BatchListPolicyAttachments#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListPolicyAttachments.Builder#build()} is called immediately
         * and its result is passed to {@link #listPolicyAttachments(BatchListPolicyAttachments)}.
         * 
         * @param listPolicyAttachments
         *        a consumer that will call methods on {@link BatchListPolicyAttachments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listPolicyAttachments(BatchListPolicyAttachments)
         */
        default Builder listPolicyAttachments(Consumer<BatchListPolicyAttachments.Builder> listPolicyAttachments) {
            return listPolicyAttachments(BatchListPolicyAttachments.builder().applyMutation(listPolicyAttachments).build());
        }

        /**
         * <p>
         * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
         * present, an empty list is returned. If policies are present, and if some objects don't have the policies
         * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
         * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to
         * the root from the target object are ignored. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * 
         * @param lookupPolicy
         *        Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no
         *        policies present, an empty list is returned. If policies are present, and if some objects don't have
         *        the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are
         *        present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>.
         *        Paths that don't lead to the root from the target object are ignored. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookupPolicy(BatchLookupPolicy lookupPolicy);

        /**
         * <p>
         * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
         * present, an empty list is returned. If policies are present, and if some objects don't have the policies
         * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
         * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to
         * the root from the target object are ignored. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchLookupPolicy.Builder} avoiding the need to
         * create one manually via {@link BatchLookupPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchLookupPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #lookupPolicy(BatchLookupPolicy)}.
         * 
         * @param lookupPolicy
         *        a consumer that will call methods on {@link BatchLookupPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lookupPolicy(BatchLookupPolicy)
         */
        default Builder lookupPolicy(Consumer<BatchLookupPolicy.Builder> lookupPolicy) {
            return lookupPolicy(BatchLookupPolicy.builder().applyMutation(lookupPolicy).build());
        }

        /**
         * <p>
         * Lists objects attached to the specified index.
         * </p>
         * 
         * @param listIndex
         *        Lists objects attached to the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listIndex(BatchListIndex listIndex);

        /**
         * <p>
         * Lists objects attached to the specified index.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListIndex.Builder} avoiding the need to
         * create one manually via {@link BatchListIndex#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListIndex.Builder#build()} is called immediately and its
         * result is passed to {@link #listIndex(BatchListIndex)}.
         * 
         * @param listIndex
         *        a consumer that will call methods on {@link BatchListIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listIndex(BatchListIndex)
         */
        default Builder listIndex(Consumer<BatchListIndex.Builder> listIndex) {
            return listIndex(BatchListIndex.builder().applyMutation(listIndex).build());
        }

        /**
         * <p>
         * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param listOutgoingTypedLinks
         *        Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It
         *        also supports filtering by typed link facet and identity attributes. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinks listOutgoingTypedLinks);

        /**
         * <p>
         * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListOutgoingTypedLinks.Builder} avoiding
         * the need to create one manually via {@link BatchListOutgoingTypedLinks#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListOutgoingTypedLinks.Builder#build()} is called
         * immediately and its result is passed to {@link #listOutgoingTypedLinks(BatchListOutgoingTypedLinks)}.
         * 
         * @param listOutgoingTypedLinks
         *        a consumer that will call methods on {@link BatchListOutgoingTypedLinks.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listOutgoingTypedLinks(BatchListOutgoingTypedLinks)
         */
        default Builder listOutgoingTypedLinks(Consumer<BatchListOutgoingTypedLinks.Builder> listOutgoingTypedLinks) {
            return listOutgoingTypedLinks(BatchListOutgoingTypedLinks.builder().applyMutation(listOutgoingTypedLinks).build());
        }

        /**
         * <p>
         * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param listIncomingTypedLinks
         *        Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It
         *        also supports filtering by typed link facet and identity attributes. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listIncomingTypedLinks(BatchListIncomingTypedLinks listIncomingTypedLinks);

        /**
         * <p>
         * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchListIncomingTypedLinks.Builder} avoiding
         * the need to create one manually via {@link BatchListIncomingTypedLinks#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListIncomingTypedLinks.Builder#build()} is called
         * immediately and its result is passed to {@link #listIncomingTypedLinks(BatchListIncomingTypedLinks)}.
         * 
         * @param listIncomingTypedLinks
         *        a consumer that will call methods on {@link BatchListIncomingTypedLinks.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listIncomingTypedLinks(BatchListIncomingTypedLinks)
         */
        default Builder listIncomingTypedLinks(Consumer<BatchListIncomingTypedLinks.Builder> listIncomingTypedLinks) {
            return listIncomingTypedLinks(BatchListIncomingTypedLinks.builder().applyMutation(listIncomingTypedLinks).build());
        }

        /**
         * <p>
         * Retrieves attributes that are associated with a typed link.
         * </p>
         * 
         * @param getLinkAttributes
         *        Retrieves attributes that are associated with a typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder getLinkAttributes(BatchGetLinkAttributes getLinkAttributes);

        /**
         * <p>
         * Retrieves attributes that are associated with a typed link.
         * </p>
         * This is a convenience that creates an instance of the {@link BatchGetLinkAttributes.Builder} avoiding the
         * need to create one manually via {@link BatchGetLinkAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchGetLinkAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #getLinkAttributes(BatchGetLinkAttributes)}.
         * 
         * @param getLinkAttributes
         *        a consumer that will call methods on {@link BatchGetLinkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #getLinkAttributes(BatchGetLinkAttributes)
         */
        default Builder getLinkAttributes(Consumer<BatchGetLinkAttributes.Builder> getLinkAttributes) {
            return getLinkAttributes(BatchGetLinkAttributes.builder().applyMutation(getLinkAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BatchListObjectAttributes listObjectAttributes;

        private BatchListObjectChildren listObjectChildren;

        private BatchListAttachedIndices listAttachedIndices;

        private BatchListObjectParentPaths listObjectParentPaths;

        private BatchGetObjectInformation getObjectInformation;

        private BatchGetObjectAttributes getObjectAttributes;

        private BatchListObjectParents listObjectParents;

        private BatchListObjectPolicies listObjectPolicies;

        private BatchListPolicyAttachments listPolicyAttachments;

        private BatchLookupPolicy lookupPolicy;

        private BatchListIndex listIndex;

        private BatchListOutgoingTypedLinks listOutgoingTypedLinks;

        private BatchListIncomingTypedLinks listIncomingTypedLinks;

        private BatchGetLinkAttributes getLinkAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadOperation model) {
            listObjectAttributes(model.listObjectAttributes);
            listObjectChildren(model.listObjectChildren);
            listAttachedIndices(model.listAttachedIndices);
            listObjectParentPaths(model.listObjectParentPaths);
            getObjectInformation(model.getObjectInformation);
            getObjectAttributes(model.getObjectAttributes);
            listObjectParents(model.listObjectParents);
            listObjectPolicies(model.listObjectPolicies);
            listPolicyAttachments(model.listPolicyAttachments);
            lookupPolicy(model.lookupPolicy);
            listIndex(model.listIndex);
            listOutgoingTypedLinks(model.listOutgoingTypedLinks);
            listIncomingTypedLinks(model.listIncomingTypedLinks);
            getLinkAttributes(model.getLinkAttributes);
        }

        public final BatchListObjectAttributes.Builder getListObjectAttributes() {
            return listObjectAttributes != null ? listObjectAttributes.toBuilder() : null;
        }

        public final void setListObjectAttributes(BatchListObjectAttributes.BuilderImpl listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes != null ? listObjectAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder listObjectAttributes(BatchListObjectAttributes listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes;
            return this;
        }

        public final BatchListObjectChildren.Builder getListObjectChildren() {
            return listObjectChildren != null ? listObjectChildren.toBuilder() : null;
        }

        public final void setListObjectChildren(BatchListObjectChildren.BuilderImpl listObjectChildren) {
            this.listObjectChildren = listObjectChildren != null ? listObjectChildren.build() : null;
        }

        @Override
        @Transient
        public final Builder listObjectChildren(BatchListObjectChildren listObjectChildren) {
            this.listObjectChildren = listObjectChildren;
            return this;
        }

        public final BatchListAttachedIndices.Builder getListAttachedIndices() {
            return listAttachedIndices != null ? listAttachedIndices.toBuilder() : null;
        }

        public final void setListAttachedIndices(BatchListAttachedIndices.BuilderImpl listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices != null ? listAttachedIndices.build() : null;
        }

        @Override
        @Transient
        public final Builder listAttachedIndices(BatchListAttachedIndices listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices;
            return this;
        }

        public final BatchListObjectParentPaths.Builder getListObjectParentPaths() {
            return listObjectParentPaths != null ? listObjectParentPaths.toBuilder() : null;
        }

        public final void setListObjectParentPaths(BatchListObjectParentPaths.BuilderImpl listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths != null ? listObjectParentPaths.build() : null;
        }

        @Override
        @Transient
        public final Builder listObjectParentPaths(BatchListObjectParentPaths listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths;
            return this;
        }

        public final BatchGetObjectInformation.Builder getGetObjectInformation() {
            return getObjectInformation != null ? getObjectInformation.toBuilder() : null;
        }

        public final void setGetObjectInformation(BatchGetObjectInformation.BuilderImpl getObjectInformation) {
            this.getObjectInformation = getObjectInformation != null ? getObjectInformation.build() : null;
        }

        @Override
        @Transient
        public final Builder getObjectInformation(BatchGetObjectInformation getObjectInformation) {
            this.getObjectInformation = getObjectInformation;
            return this;
        }

        public final BatchGetObjectAttributes.Builder getGetObjectAttributes() {
            return getObjectAttributes != null ? getObjectAttributes.toBuilder() : null;
        }

        public final void setGetObjectAttributes(BatchGetObjectAttributes.BuilderImpl getObjectAttributes) {
            this.getObjectAttributes = getObjectAttributes != null ? getObjectAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder getObjectAttributes(BatchGetObjectAttributes getObjectAttributes) {
            this.getObjectAttributes = getObjectAttributes;
            return this;
        }

        public final BatchListObjectParents.Builder getListObjectParents() {
            return listObjectParents != null ? listObjectParents.toBuilder() : null;
        }

        public final void setListObjectParents(BatchListObjectParents.BuilderImpl listObjectParents) {
            this.listObjectParents = listObjectParents != null ? listObjectParents.build() : null;
        }

        @Override
        @Transient
        public final Builder listObjectParents(BatchListObjectParents listObjectParents) {
            this.listObjectParents = listObjectParents;
            return this;
        }

        public final BatchListObjectPolicies.Builder getListObjectPolicies() {
            return listObjectPolicies != null ? listObjectPolicies.toBuilder() : null;
        }

        public final void setListObjectPolicies(BatchListObjectPolicies.BuilderImpl listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies != null ? listObjectPolicies.build() : null;
        }

        @Override
        @Transient
        public final Builder listObjectPolicies(BatchListObjectPolicies listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies;
            return this;
        }

        public final BatchListPolicyAttachments.Builder getListPolicyAttachments() {
            return listPolicyAttachments != null ? listPolicyAttachments.toBuilder() : null;
        }

        public final void setListPolicyAttachments(BatchListPolicyAttachments.BuilderImpl listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments != null ? listPolicyAttachments.build() : null;
        }

        @Override
        @Transient
        public final Builder listPolicyAttachments(BatchListPolicyAttachments listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments;
            return this;
        }

        public final BatchLookupPolicy.Builder getLookupPolicy() {
            return lookupPolicy != null ? lookupPolicy.toBuilder() : null;
        }

        public final void setLookupPolicy(BatchLookupPolicy.BuilderImpl lookupPolicy) {
            this.lookupPolicy = lookupPolicy != null ? lookupPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder lookupPolicy(BatchLookupPolicy lookupPolicy) {
            this.lookupPolicy = lookupPolicy;
            return this;
        }

        public final BatchListIndex.Builder getListIndex() {
            return listIndex != null ? listIndex.toBuilder() : null;
        }

        public final void setListIndex(BatchListIndex.BuilderImpl listIndex) {
            this.listIndex = listIndex != null ? listIndex.build() : null;
        }

        @Override
        @Transient
        public final Builder listIndex(BatchListIndex listIndex) {
            this.listIndex = listIndex;
            return this;
        }

        public final BatchListOutgoingTypedLinks.Builder getListOutgoingTypedLinks() {
            return listOutgoingTypedLinks != null ? listOutgoingTypedLinks.toBuilder() : null;
        }

        public final void setListOutgoingTypedLinks(BatchListOutgoingTypedLinks.BuilderImpl listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks != null ? listOutgoingTypedLinks.build() : null;
        }

        @Override
        @Transient
        public final Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinks listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks;
            return this;
        }

        public final BatchListIncomingTypedLinks.Builder getListIncomingTypedLinks() {
            return listIncomingTypedLinks != null ? listIncomingTypedLinks.toBuilder() : null;
        }

        public final void setListIncomingTypedLinks(BatchListIncomingTypedLinks.BuilderImpl listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks != null ? listIncomingTypedLinks.build() : null;
        }

        @Override
        @Transient
        public final Builder listIncomingTypedLinks(BatchListIncomingTypedLinks listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks;
            return this;
        }

        public final BatchGetLinkAttributes.Builder getGetLinkAttributes() {
            return getLinkAttributes != null ? getLinkAttributes.toBuilder() : null;
        }

        public final void setGetLinkAttributes(BatchGetLinkAttributes.BuilderImpl getLinkAttributes) {
            this.getLinkAttributes = getLinkAttributes != null ? getLinkAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder getLinkAttributes(BatchGetLinkAttributes getLinkAttributes) {
            this.getLinkAttributes = getLinkAttributes;
            return this;
        }

        @Override
        public BatchReadOperation build() {
            return new BatchReadOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
