/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <a>AttachObject</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAttachObject implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchAttachObject.Builder, BatchAttachObject> {
    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ParentReference")
            .getter(getter(BatchAttachObject::parentReference)).setter(setter(Builder::parentReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()).build();

    private static final SdkField<ObjectReference> CHILD_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ChildReference")
            .getter(getter(BatchAttachObject::childReference)).setter(setter(Builder::childReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildReference").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkName").getter(getter(BatchAttachObject::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_REFERENCE_FIELD,
            CHILD_REFERENCE_FIELD, LINK_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final ObjectReference parentReference;

    private final ObjectReference childReference;

    private final String linkName;

    private BatchAttachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.childReference = builder.childReference;
        this.linkName = builder.linkName;
    }

    /**
     * <p>
     * The parent object reference.
     * </p>
     * 
     * @return The parent object reference.
     */
    public final ObjectReference parentReference() {
        return parentReference;
    }

    /**
     * <p>
     * The child object reference that is to be attached to the object.
     * </p>
     * 
     * @return The child object reference that is to be attached to the object.
     */
    public final ObjectReference childReference() {
        return childReference;
    }

    /**
     * <p>
     * The name of the link.
     * </p>
     * 
     * @return The name of the link.
     */
    public final String linkName() {
        return linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(childReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachObject)) {
            return false;
        }
        BatchAttachObject other = (BatchAttachObject) obj;
        return Objects.equals(parentReference(), other.parentReference())
                && Objects.equals(childReference(), other.childReference()) && Objects.equals(linkName(), other.linkName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAttachObject").add("ParentReference", parentReference())
                .add("ChildReference", childReference()).add("LinkName", linkName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParentReference":
            return Optional.ofNullable(clazz.cast(parentReference()));
        case "ChildReference":
            return Optional.ofNullable(clazz.cast(childReference()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAttachObject, T> g) {
        return obj -> g.apply((BatchAttachObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchAttachObject> {
        /**
         * <p>
         * The parent object reference.
         * </p>
         * 
         * @param parentReference
         *        The parent object reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentReference(ObjectReference parentReference);

        /**
         * <p>
         * The parent object reference.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #parentReference(ObjectReference)}.
         * 
         * @param parentReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentReference(ObjectReference)
         */
        default Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return parentReference(ObjectReference.builder().applyMutation(parentReference).build());
        }

        /**
         * <p>
         * The child object reference that is to be attached to the object.
         * </p>
         * 
         * @param childReference
         *        The child object reference that is to be attached to the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childReference(ObjectReference childReference);

        /**
         * <p>
         * The child object reference that is to be attached to the object.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #childReference(ObjectReference)}.
         * 
         * @param childReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childReference(ObjectReference)
         */
        default Builder childReference(Consumer<ObjectReference.Builder> childReference) {
            return childReference(ObjectReference.builder().applyMutation(childReference).build());
        }

        /**
         * <p>
         * The name of the link.
         * </p>
         * 
         * @param linkName
         *        The name of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference parentReference;

        private ObjectReference childReference;

        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachObject model) {
            parentReference(model.parentReference);
            childReference(model.childReference);
            linkName(model.linkName);
        }

        public final ObjectReference.Builder getParentReference() {
            return parentReference != null ? parentReference.toBuilder() : null;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        @Override
        @Transient
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final ObjectReference.Builder getChildReference() {
            return childReference != null ? childReference.toBuilder() : null;
        }

        public final void setChildReference(ObjectReference.BuilderImpl childReference) {
            this.childReference = childReference != null ? childReference.build() : null;
        }

        @Override
        @Transient
        public final Builder childReference(ObjectReference childReference) {
            this.childReference = childReference;
            return this;
        }

        public final String getLinkName() {
            return linkName;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        @Transient
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        @Override
        public BatchAttachObject build() {
            return new BatchAttachObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
