/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplySchemaResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ApplySchemaResponse.Builder, ApplySchemaResponse> {
    private static final SdkField<String> APPLIED_SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppliedSchemaArn").getter(getter(ApplySchemaResponse::appliedSchemaArn))
            .setter(setter(Builder::appliedSchemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedSchemaArn").build()).build();

    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(ApplySchemaResponse::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_SCHEMA_ARN_FIELD,
            DIRECTORY_ARN_FIELD));

    private final String appliedSchemaArn;

    private final String directoryArn;

    private ApplySchemaResponse(BuilderImpl builder) {
        super(builder);
        this.appliedSchemaArn = builder.appliedSchemaArn;
        this.directoryArn = builder.directoryArn;
    }

    /**
     * <p>
     * The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use this ARN to
     * describe the schema information applied on this directory. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use
     *         this ARN to describe the schema information applied on this directory. For more information, see
     *         <a>arns</a>.
     */
    public final String appliedSchemaArn() {
        return appliedSchemaArn;
    }

    /**
     * <p>
     * The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appliedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySchemaResponse)) {
            return false;
        }
        ApplySchemaResponse other = (ApplySchemaResponse) obj;
        return Objects.equals(appliedSchemaArn(), other.appliedSchemaArn())
                && Objects.equals(directoryArn(), other.directoryArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplySchemaResponse").add("AppliedSchemaArn", appliedSchemaArn())
                .add("DirectoryArn", directoryArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppliedSchemaArn":
            return Optional.ofNullable(clazz.cast(appliedSchemaArn()));
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplySchemaResponse, T> g) {
        return obj -> g.apply((ApplySchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ApplySchemaResponse> {
        /**
         * <p>
         * The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use this
         * ARN to describe the schema information applied on this directory. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param appliedSchemaArn
         *        The applied schema ARN that is associated with the copied schema in the <a>Directory</a>. You can use
         *        this ARN to describe the schema information applied on this directory. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedSchemaArn(String appliedSchemaArn);

        /**
         * <p>
         * The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The ARN that is associated with the <a>Directory</a>. For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private String appliedSchemaArn;

        private String directoryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySchemaResponse model) {
            super(model);
            appliedSchemaArn(model.appliedSchemaArn);
            directoryArn(model.directoryArn);
        }

        public final String getAppliedSchemaArn() {
            return appliedSchemaArn;
        }

        public final void setAppliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
        }

        @Override
        @Transient
        public final Builder appliedSchemaArn(String appliedSchemaArn) {
            this.appliedSchemaArn = appliedSchemaArn;
            return this;
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        @Transient
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        @Override
        public ApplySchemaResponse build() {
            return new ApplySchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
